# 機能設計書 60-Kubernetesクラスター連携

## 概要

本ドキュメントは、GitLabとKubernetesクラスターを連携させる機能について記述した機能設計書である。

### 本機能の処理概要

Kubernetesクラスター連携機能は、GitLabのCI/CDパイプラインやAuto DevOpsからKubernetesクラスターへのデプロイを実現するための統合機能である。

**業務上の目的・背景**：モダンなアプリケーション開発では、コンテナオーケストレーションプラットフォームであるKubernetesが広く採用されている。GitLabとKubernetesを連携させることで、CI/CDパイプラインから直接Kubernetesクラスターへデプロイでき、Auto DevOpsによる自動化されたDevOpsパイプラインを実現できる。

**機能の利用シーン**：
- CI/CDパイプラインからKubernetesクラスターへアプリケーションをデプロイする場合
- Auto DevOpsを使用して自動化されたデプロイメントを設定する場合
- 複数の環境（production/staging/development）を管理する場合
- GCP/AWSなどのクラウドプロバイダーでKubernetesクラスターを作成する場合
- 既存のKubernetesクラスターをGitLabに登録する場合

**主要な処理内容**：
1. Kubernetesクラスターの登録（ユーザー提供/GCP/AWS）
2. クラスター設定の更新（有効化/無効化、環境スコープ）
3. クラスターの削除（クリーンアップオプション付き）
4. クラスターステータスの監視（接続確認、ノード情報）
5. CI/CD変数の自動生成（KUBE_URL、KUBE_TOKEN等）

**関連システム・外部連携**：
- Kubernetes API
- Google Cloud Platform (GCP)
- Amazon Web Services (AWS)
- Auto DevOps

**権限による制御**：
- クラスター閲覧: `read_cluster`権限が必要
- クラスター作成: `create_cluster`権限が必要
- クラスター更新: `update_cluster`権限が必要
- クラスター削除: `admin_cluster`権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 84 | Kubernetesクラスター一覧 | 主画面 | クラスター一覧の表示 |
| 85 | Kubernetesクラスター詳細 | 主画面 | クラスター設定の編集、削除 |
| 86 | Kubernetesクラスター接続 | 主画面 | 新規クラスターの登録 |

## 機能種別

CRUD操作 / 外部システム連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes | クラスター名 | cluster_nameバリデーション |
| api_url | String | Yes | Kubernetes API URL | 公開URL、最大2048文字 |
| token | String | Yes | 認証トークン | 最大8192文字 |
| ca_cert | String | No | CA証明書 | 証明書形式、最大65535文字 |
| namespace | String | No | デフォルト名前空間 | 1-63文字、kubernetes形式 |
| enabled | Boolean | No | 有効/無効 | - |
| environment_scope | String | No | 環境スコープ | 最大255文字、デフォルト: `*` |
| managed | Boolean | No | GitLabによる管理 | - |
| namespace_per_environment | Boolean | No | 環境ごとの名前空間 | - |
| base_domain | String | No | ベースドメイン | ホスト名形式 |
| management_project_id | Integer | No | 管理プロジェクトID | - |

### 入力データソース

- 画面入力（クラスター登録フォーム）
- APIリクエスト
- GCP/AWSプロバイダーからの自動設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | クラスターID |
| name | String | クラスター名 |
| cluster_type | String | クラスター種別（instance/group/project） |
| provider_type | String | プロバイダー種別（user/gcp/aws） |
| platform_type | String | プラットフォーム種別（kubernetes） |
| enabled | Boolean | 有効状態 |
| environment_scope | String | 環境スコープ |
| status | String | 接続ステータス |
| nodes | Array | ノード情報（ReactiveCacheから取得） |

### 出力先

- 画面表示（クラスター一覧、詳細）
- JSONレスポンス（API）
- CI/CD変数（KUBE_URL、KUBE_TOKEN、KUBE_NAMESPACE等）

## 処理フロー

### 処理シーケンス

```
1. 認証・権限チェック
   └─ 操作に応じた権限確認

2. クラスター操作
   └─ 登録/更新/削除

3. Kubernetes API接続（ReactiveCacheで非同期）
   └─ 接続確認、ノード情報取得

4. CI/CD変数の生成
   └─ デプロイ時に自動注入

5. レスポンス生成
   └─ HTML/JSONレスポンス
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|一覧| C[ClusterAncestorsFinder]
    B -->|登録| D{create権限?}
    B -->|更新| E{update権限?}
    B -->|削除| F{admin権限?}
    D -->|No| G[403 Access Denied]
    D -->|Yes| H[CreateService実行]
    E -->|No| G
    E -->|Yes| I[UpdateService実行]
    F -->|No| G
    F -->|Yes| J[DestroyService実行]
    C --> K[ClusterSerializer]
    H --> L{成功?}
    I --> L
    J --> L
    L -->|Yes| M[ReactiveCacheでKubernetes接続]
    L -->|No| N[エラーレスポンス]
    M --> K
    K --> O[JSON/HTMLレスポンス]
    O --> P[終了]
    N --> P
    G --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-60-01 | 環境スコープ一意性 | 同一クラスタブル内で環境スコープは一意 | 作成/更新時 |
| BR-60-02 | デフォルト環境スコープ | 未指定時は`*`（全環境対応） | 作成時 |
| BR-60-03 | クラスター種別 | instance_type/group_type/project_typeのいずれか | 作成時 |
| BR-60-04 | 名前空間制限 | gitlab-managed-appsは予約済み | 作成/更新時 |
| BR-60-05 | 管理プロジェクト | 管理プロジェクトへのアクセス権が必要 | 設定時 |
| BR-60-06 | Helmバージョン | helm_major_versionは2または3（デフォルト: 3） | 作成時 |
| BR-60-07 | Kubernetes最小バージョン | K8s 1.23以上が必要 | 接続時 |

### 計算ロジック

- `status_name`: provider状態、cleanup状態、接続状態から決定
- `kube_ingress_domain`: cluster.domain または instance_domain
- ポーリング間隔: 10秒（STATUS_POLLING_INTERVAL）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| クラスター登録 | clusters | INSERT | クラスターレコード作成 |
| クラスター登録 | cluster_platforms_kubernetes | INSERT | プラットフォーム情報作成 |
| クラスター登録 | cluster_projects/cluster_groups | INSERT | 関連付け作成 |
| クラスター更新 | clusters | UPDATE | クラスター設定更新 |
| クラスター更新 | cluster_platforms_kubernetes | UPDATE | プラットフォーム設定更新 |
| クラスター削除 | clusters | DELETE | クラスター削除（カスケード） |

### テーブル別操作詳細

#### clusters

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | ユーザー入力値 | - |
| INSERT | cluster_type | 1(instance)/2(group)/3(project) | - |
| INSERT | provider_type | 0(user)/1(gcp)/2(aws) | - |
| INSERT | platform_type | 1(kubernetes) | - |
| INSERT | enabled | true/false | - |
| INSERT | environment_scope | 入力値または`*` | 最大255文字 |
| UPDATE | cleanup_status | 1-5 | クリーンアップ状態 |

#### cluster_platforms_kubernetes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | api_url | Kubernetes API URL | 最大2048文字 |
| INSERT | token_encrypted | 暗号化トークン | AES-256-CBC |
| INSERT | ca_cert | CA証明書 | 最大65535文字 |
| INSERT | namespace | デフォルト名前空間 | 1-63文字 |
| INSERT | authorization_type | 1(rbac)/2(abac) | デフォルト: rbac |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 403 | Access Denied | 権限不足 | 適切な権限を取得 |
| 400 | Bad Request | バリデーションエラー | 入力値を修正 |
| 404 | Not Found | クラスター未検出 | 正しいIDを確認 |
| - | Connection Error | Kubernetes API接続失敗 | API URL、トークン、CA証明書を確認 |

### リトライ仕様

- Kubernetes API接続失敗時はReactiveCacheで自動リトライ
- プロバイダー作成中は変更不可

## トランザクション仕様

- クラスター作成時はclustersとplatform情報を同一トランザクションで作成
- クリーンアップ処理は非同期ワーカーで実行

## パフォーマンス要件

- クラスター一覧取得: 1秒以内（20件/ページ）
- クラスター作成/更新: 2秒以内
- Kubernetes API接続確認: ReactiveCacheで非同期実行

## セキュリティ考慮事項

- トークンはAES-256-CBCで暗号化して保存
- CA証明書によるSSL検証
- プロジェクト/グループ/インスタンス単位での権限チェック
- 管理プロジェクトへのアクセス権検証

## 備考

- DEFAULT_ENVIRONMENT: `*`
- MAX_ENVIRONMENT_SCOPE_LENGTH: 255
- RESERVED_NAMESPACES: gitlab-managed-apps
- REQUIRED_K8S_MIN_VERSION: 23（Kubernetes 1.23）
- STATUS_POLLING_INTERVAL: 10,000ms（10秒）
- helm_major_version: デフォルト3

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cluster.rb | `app/models/clusters/cluster.rb` | クラスターの属性、関連、状態遷移を理解する |
| 1-2 | kubernetes.rb | `app/models/clusters/platforms/kubernetes.rb` | Kubernetesプラットフォーム設定を理解する |

**読解のコツ**:
- **cluster.rb 14-16行目**: 定数定義（DEFAULT_ENVIRONMENT、MAX_ENVIRONMENT_SCOPE_LENGTH）を確認
- **cluster.rb 75-89行目**: enum定義（cluster_type、platform_type、provider_type）を確認
- **cluster.rb 125-160行目**: state_machine :cleanup_statusで状態遷移を確認
- **cluster.rb 169-174行目**: `status_name`メソッドで状態決定ロジックを確認
- **cluster.rb 200-204行目**: `nodes`メソッドでReactiveCacheからのデータ取得を確認
- **kubernetes.rb 12-17行目**: 定数定義（RESERVED_NAMESPACES、REQUIRED_K8S_MIN_VERSION等）を確認
- **kubernetes.rb 36-44行目**: トークン暗号化（attr_encrypted）を確認
- **kubernetes.rb 73-77行目**: enum :authorization_typeを確認
- **kubernetes.rb 94-118行目**: `predefined_variables`でCI/CD変数生成を確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusters_controller.rb | `app/controllers/clusters/clusters_controller.rb` | 各アクションの処理フローを確認 |

**主要処理フロー**:
- **6-11行目**: before_actionで権限チェックとフィーチャーフラグ確認
- **15行目**: STATUS_POLLING_INTERVAL定義（10秒）
- **17-32行目**: indexアクションでクラスター一覧取得（20件/ページ）
- **47-68行目**: updateアクションでUpdateService呼び出し
- **70-77行目**: destroyアクションでDestroyService呼び出し
- **79-90行目**: create_userアクションでユーザー提供クラスター登録
- **92-96行目**: clear_cacheアクションでキャッシュクリア
- **98-113行目**: migrateアクションでエージェント移行

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/clusters/create_service.rb` | クラスター作成のビジネスロジック |
| 3-2 | update_service.rb | `app/services/clusters/update_service.rb` | クラスター更新ロジック |
| 3-3 | destroy_service.rb | `app/services/clusters/destroy_service.rb` | クラスター削除ロジック |

**主要処理フロー**:
- **create_service.rb 12-28行目**: executeメソッドでクラスター作成
- **create_service.rb 40-50行目**: clusterable_paramsでcluster_type決定
- **create_service.rb 53-56行目**: 管理プロジェクト権限検証

### プログラム呼び出し階層図

```
Clusters::ClustersController
    │
    ├─ #index
    │      ├─ ClusterAncestorsFinder#execute
    │      └─ ClusterSerializer#represent_list
    │
    ├─ #create_user
    │      └─ Clusters::CreateService#execute
    │             └─ Clusters::Cluster.new.save
    │
    ├─ #update
    │      └─ Clusters::UpdateService#execute
    │
    ├─ #destroy
    │      └─ Clusters::DestroyService#execute
    │             └─ state_machine (cleanup処理)
    │
    └─ #cluster_status
           └─ ClusterSerializer#represent_status
                  └─ ReactiveCaching (Kubernetes API)
```

### データフロー図

```
[入力]               [処理]                        [出力]

クラスター設定
フォーム ───────▶ ClustersController ───────▶ クラスター一覧/詳細
                      │
                      ▼
              Clusters::Cluster
                      │
          ┌───────────┼───────────┐
          ▼           ▼           ▼
      clusters   platform_    cluster_
                 kubernetes   projects/groups

                      │
                      ▼
              ReactiveCaching
                      │
                      ▼
              Kubernetes API ────▶ pods/deployments/ingresses
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cluster.rb | `app/models/clusters/cluster.rb` | モデル | クラスターのデータモデル |
| kubernetes.rb | `app/models/clusters/platforms/kubernetes.rb` | モデル | Kubernetesプラットフォーム設定 |
| gcp.rb | `app/models/clusters/providers/gcp.rb` | モデル | GCPプロバイダー設定 |
| aws.rb | `app/models/clusters/providers/aws.rb` | モデル | AWSプロバイダー設定 |
| clusters_controller.rb | `app/controllers/clusters/clusters_controller.rb` | コントローラー | クラスター操作のエンドポイント |
| create_service.rb | `app/services/clusters/create_service.rb` | サービス | クラスター作成ロジック |
| update_service.rb | `app/services/clusters/update_service.rb` | サービス | クラスター更新ロジック |
| destroy_service.rb | `app/services/clusters/destroy_service.rb` | サービス | クラスター削除ロジック |
| build_service.rb | `app/services/clusters/build_service.rb` | サービス | クラスタービルドロジック |
| cluster_serializer.rb | `app/serializers/cluster_serializer.rb` | シリアライザー | JSON出力フォーマット |
| cluster_ancestors_finder.rb | `app/finders/cluster_ancestors_finder.rb` | Finder | 階層クラスター検索 |
| project_namespace_service.rb | `app/services/clusters/cleanup/project_namespace_service.rb` | サービス | 名前空間クリーンアップ |
| service_account_service.rb | `app/services/clusters/cleanup/service_account_service.rb` | サービス | サービスアカウントクリーンアップ |
