# 機能設計書 66-依存関係スキャン

## 概要

本ドキュメントは、GitLabにおける依存関係スキャン（Dependency Scanning）機能の設計仕様を記載する。アプリケーションの依存ライブラリに含まれる既知の脆弱性を自動的に検出し、セキュアな開発を支援する機能である。

### 本機能の処理概要

依存関係スキャン機能は、CI/CDパイプライン内でプロジェクトの依存関係（パッケージ）を分析し、既知の脆弱性データベースと照合して脆弱性を検出する。検出結果はセキュリティレポートとしてJSONファイルで出力され、GitLab上で一元管理される。

**業務上の目的・背景**：オープンソースライブラリの利用が一般化する中、サードパーティコンポーネントの脆弱性管理は重要なセキュリティ課題である。本機能により、開発者が使用する依存ライブラリの脆弱性を継続的に検出し、早期対応を可能にする。サプライチェーン攻撃への対策として、ソフトウェア構成分析（SCA）の自動化を実現する。

**機能の利用シーン**：
- コードプッシュ時の依存関係脆弱性チェック
- マージリクエストでの脆弱性レポート表示
- CycloneDX形式のSBOM（Software Bill of Materials）生成
- 脆弱性管理ダッシュボードでの一元管理
- コンプライアンス監査のためのライセンス確認

**主要な処理内容**：
1. CI/CDパイプラインでのアナライザー実行
2. パッケージマニフェストファイル（lock files）の解析
3. 脆弱性データベースとの照合
4. セキュリティレポート（JSON/CycloneDX）の生成
5. マージリクエストでの差分表示
6. 脆弱性ステータスの管理

**関連システム・外部連携**：
- GitLab Runner（アナライザー実行）
- Gemnasiumアナライザー群
- GitLab Advisory Database（脆弱性データベース）
- NVD（National Vulnerability Database）
- CycloneDX SBOM形式

**権限による制御**：
- `read_security_configuration`権限：セキュリティ設定の閲覧
- `read_vulnerability`権限：脆弱性情報の閲覧
- `admin_vulnerability`権限：脆弱性ステータスの変更

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 125 | セキュリティ設定 | 主機能 | 依存関係スキャン設定の管理 |

## 機能種別

セキュリティスキャン / データ解析 / レポート生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| DS_EXCLUDED_ANALYZERS | String | No | 除外するアナライザー（カンマ区切り） | - |
| DS_EXCLUDED_PATHS | String | No | スキャン除外パス | デフォルト: spec, test, tests, tmp, node_modules |
| DS_MAJOR_VERSION | Integer | No | アナライザーメジャーバージョン | デフォルト: 6 |
| DS_SCHEMA_MODEL | Integer | No | スキーマモデルバージョン | デフォルト: 15 |
| DEPENDENCY_SCANNING_DISABLED | String | No | スキャン無効化フラグ | true/1で無効化 |
| PIP_REQUIREMENTS_FILE | String | No | Pythonのrequirementsファイルパス | - |
| GEMNASIUM_LIBRARY_SCAN_ENABLED | String | No | ライブラリスキャン有効化 | デフォルト: true |

### 入力データソース

- パッケージマニフェストファイル
  - Gemfile.lock（Ruby）
  - package-lock.json / yarn.lock / pnpm-lock.yaml（JavaScript）
  - composer.lock（PHP）
  - go.sum（Go）
  - pom.xml / build.gradle（Java）
  - requirements.txt / Pipfile.lock / poetry.lock / uv.lock（Python）
  - packages.lock.json（NuGet）
  - conan.lock（Conan）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| gl-dependency-scanning-report.json | JSON | 依存関係スキャン結果レポート |
| gl-sbom-*.cdx.json | JSON | CycloneDX形式のSBOMファイル |
| report_type | String | dependency_scanning |
| findings | Array | 検出された脆弱性のリスト |
| severity | String | 重大度（info, unknown, low, medium, high, critical） |
| identifiers | Array | 識別子（CVE、CWE等） |

### 出力先

- CI/CDジョブアーティファクト
- セキュリティダッシュボード
- マージリクエストウィジェット
- 依存関係リスト

## 処理フロー

### 処理シーケンス

```
1. CI/CDパイプライン実行
   └─ 依存関係スキャンジョブ検出
   └─ アナライザー選択（言語/フレームワーク判定）

2. アナライザー実行
   └─ gemnasium（汎用）
   └─ gemnasium-maven（Java）
   └─ gemnasium-python（Python）

3. スキャン処理
   └─ パッケージマニフェスト解析
   └─ 依存関係ツリー構築
   └─ 脆弱性データベース照合
   └─ CycloneDX SBOM生成

4. レポート生成
   └─ gl-dependency-scanning-report.json作成
   └─ gl-sbom-*.cdx.json作成
   └─ アーティファクトとしてアップロード

5. 結果表示
   └─ マージリクエストウィジェット
   └─ セキュリティダッシュボード
```

### フローチャート

```mermaid
flowchart TD
    A[CI/CDパイプライン] --> B{パッケージファイル存在?}
    B -->|Yes| C[アナライザー選択]
    B -->|No| Z[スキップ]
    C --> D{言語判定}
    D -->|Ruby/JS/Go/etc| E[gemnasium]
    D -->|Java/Maven/Gradle| F[gemnasium-maven]
    D -->|Python| G[gemnasium-python]
    E --> H[脆弱性DB照合]
    F --> H
    G --> H
    H --> I[レポート生成]
    I --> J[CycloneDX SBOM]
    J --> K[MRウィジェット表示]
    J --> L[ダッシュボード表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | サポートPURL種別 | composer, conan, gem, golang, maven, npm, nuget, pypi, cargo, swift, conda, pubの12種類 | 依存関係解析時 |
| BR-02 | 除外パスデフォルト | spec, test, tests, tmp, node_modulesを除外 | パス指定なし時 |
| BR-03 | アナライザー自動選択 | ファイル拡張子・ファイル名でアナライザーを自動選択 | ジョブ実行時 |
| BR-04 | FIPSモード対応 | FIPSモード時は専用イメージ使用 | CI_GITLAB_FIPS_MODE=true |
| BR-05 | MRパイプライン制御 | AST_ENABLE_MR_PIPELINES設定で実行タイミング制御 | MR存在時 |
| BR-06 | アクセス制御 | アーティファクトはdeveloper以上でアクセス可能 | レポート取得時 |

### 計算ロジック

- アナライザー選択ルール:
  - `gemnasium`: Gemfile.lock, composer.lock, go.sum, npm系lock files等
  - `gemnasium-maven`: build.gradle, build.gradle.kts, build.sbt, pom.xml
  - `gemnasium-python`: requirements.txt, Pipfile, poetry.lock, uv.lock等

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スキャン結果取り込み | ci_job_artifacts | INSERT | レポートファイル保存 |
| 脆弱性作成 | vulnerability_findings | INSERT | 検出項目の保存 |
| SBOM保存 | sbom_components | INSERT | ソフトウェア構成情報 |

### テーブル別操作詳細

#### ci_job_artifacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | file_type | 6（dependency_scanning） | enum値 |
| INSERT | file_format | 3（raw） | 未圧縮 |
| INSERT | file | レポートファイル | JSON形式 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------
| - | パッケージファイル未検出 | 対象ファイルが存在しない | プロジェクト構成を確認 |
| - | アナライザーエラー | スキャン実行失敗 | ログを確認しリトライ |
| - | 脆弱性DB接続エラー | DBアクセス失敗 | ネットワーク設定確認 |

### リトライ仕様

アナライザーエラー時、CI/CDジョブのリトライ機構を使用（allow_failure: true設定）。

## トランザクション仕様

- レポート解析とFinding作成は同一トランザクション
- 大量のFinding処理時はバッチ処理

## パフォーマンス要件

- スキャン対象ファイル探索のパス除外によるパフォーマンス最適化
- DS_EXCLUDED_PATHSでスキャン範囲を制限可能

## セキュリティ考慮事項

- 脆弱性情報は機密性が高いため、適切なアクセス制御が必要
- アーティファクトアクセスはdeveloper以上に制限
- GITLAB_FEATURES設定で機能の有効/無効を制御

## 備考

- 本機能はGitLab Ultimate（EE）で提供される高度な機能を含む
- feature_category: `dependency_scanning`
- アナライザーイメージは$SECURE_ANALYZERS_PREFIXで指定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とenum定義を理解する

依存関係スキャンで使用される主要なデータ型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sbom.rb | `app/models/concerns/enums/sbom.rb` | PURL種別、コンポーネント種別の定義 |
| 1-2 | security.rb | `app/models/concerns/enums/security.rb` | アナライザー種別の定義 |
| 1-3 | job_artifact.rb | `app/models/concerns/enums/ci/job_artifact.rb` | アーティファクト種別の定義 |

**読解のコツ**:
- **sbom.rb 9-29行目**: PURL_TYPES - サポートするパッケージ種別
- **sbom.rb 55-68行目**: DEPENDENCY_SCANNING_PURL_TYPES - 依存関係スキャン対象のPURL種別
- **security.rb 7-18行目**: ANALYZER_TYPES - アナライザー種別（dependency_scanning: 4）
- **job_artifact.rb 29行目**: dependency_scanningのデフォルトファイル名
- **job_artifact.rb 164行目**: file_typeのenum値（6）

#### Step 2: CI/CDテンプレートを理解する

依存関係スキャンのCI/CD設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Dependency-Scanning.gitlab-ci.yml | `lib/gitlab/ci/templates/Jobs/Dependency-Scanning.gitlab-ci.yml` | CIテンプレート定義 |

**主要処理フロー**:
- **11-19行目**: 変数定義（DS_EXCLUDED_PATHS, DS_MAJOR_VERSION等）
- **21-32行目**: dependency_scanningベースジョブ
- **34-50行目**: .ds-analyzerテンプレート
- **52-58行目**: .cyclonedx-reportsテンプレート
- **60-62行目**: gemnasiumの対象ファイルパターン
- **64-114行目**: gemnasium-dependency_scanningジョブ定義
- **116-168行目**: gemnasium-maven-dependency_scanningジョブ
- **170-245行目**: gemnasium-python-dependency_scanningジョブ

#### Step 3: 設定サービスを理解する

依存関係スキャン設定の有効化処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | base_build_action.rb | `lib/security/ci_configuration/base_build_action.rb` | CI設定生成の基底クラス |
| 3-2 | dependency_scanning_build_action.rb | `lib/security/ci_configuration/dependency_scanning_build_action.rb` | 依存関係スキャン設定生成 |
| 3-3 | dependency_scanning_create_service.rb | `app/services/security/ci_configuration/dependency_scanning_create_service.rb` | 設定作成サービス |

**主要処理フロー**:
- **base_build_action.rb 16-22行目**: generate メソッドでCI設定生成
- **base_build_action.rb 26-31行目**: include文の生成
- **dependency_scanning_build_action.rb 13-17行目**: テンプレート選択ロジック
- **dependency_scanning_create_service.rb 8-14行目**: アクション生成
- **dependency_scanning_create_service.rb 16-18行目**: ブランチ名定義

#### Step 4: レポート解析を理解する

スキャン結果のレポート解析処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | report.rb | `lib/gitlab/ci/reports/security/report.rb` | セキュリティレポートクラス |
| 4-2 | finding.rb | `lib/gitlab/ci/reports/security/finding.rb` | 検出項目クラス |
| 4-3 | reports.rb | `lib/gitlab/ci/config/entry/reports.rb` | レポートエントリ定義 |

**主要処理フロー**:
- **report.rb 17-26行目**: コンストラクタでレポート初期化
- **report.rb 52-54行目**: add_findingでFinding追加
- **finding.rb 11-21行目**: REQUIRED_KEYS定義
- **finding.rb 116-124行目**: eql?メソッドでFinding同一性判定
- **finding.rb 135-137行目**: valid?メソッドでFinding検証
- **reports.rb 15-20行目**: ALLOWED_KEYS（dependency_scanning含む）

#### Step 5: ジョブファインダーを理解する

セキュリティジョブの検索処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | jobs_finder.rb | `app/finders/security/jobs_finder.rb` | セキュリティジョブ検索基底クラス |
| 5-2 | security_jobs_finder.rb | `app/finders/security/security_jobs_finder.rb` | セキュリティジョブ検索 |

**主要処理フロー**:
- **jobs_finder.rb 22-36行目**: コンストラクタでジョブ種別設定
- **jobs_finder.rb 38-42行目**: executeメソッドでジョブ検索
- **jobs_finder.rb 46-53行目**: find_jobs - セキュアレポート対象ジョブ取得
- **security_jobs_finder.rb 15-17行目**: allowed_job_types定義

### プログラム呼び出し階層図

```
CI/CD Pipeline
    │
    ├─ Dependency Scanning Jobs
    │      ├─ gemnasium-dependency_scanning
    │      │      └─ /analyzer run
    │      ├─ gemnasium-maven-dependency_scanning
    │      │      └─ /analyzer run
    │      └─ gemnasium-python-dependency_scanning
    │             └─ /analyzer run
    │
    └─ Report Processing
           └─ Gitlab::Ci::Reports::Security::Report
                  └─ add_finding
                         └─ Finding 作成
                                │
                                ▼
                    ci_job_artifacts (dependency_scanning)
                           └─ gl-dependency-scanning-report.json
                    ci_job_artifacts (cyclonedx)
                           └─ gl-sbom-*.cdx.json
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Package Manifest ────▶ Gemnasium Analyzer ─────────▶ gl-dependency-scanning-report.json
(Gemfile.lock,              │                              (CI/CD Artifact)
 package-lock.json,         │
 pom.xml 等)                │
                            │
                            ▼
                    GitLab Advisory DB ────────────▶ gl-sbom-*.cdx.json
                    (脆弱性照合)                     (CycloneDX SBOM)
                            │
                            ▼
                    Security::Report
                    (レポート解析)
                            │
                            ▼
                    MR Widget / Dashboard
                    (UI表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sbom.rb | `app/models/concerns/enums/sbom.rb` | Concern | PURL種別enum定義 |
| security.rb | `app/models/concerns/enums/security.rb` | Concern | アナライザー種別enum定義 |
| job_artifact.rb | `app/models/concerns/enums/ci/job_artifact.rb` | Concern | アーティファクト種別enum定義 |
| Dependency-Scanning.gitlab-ci.yml | `lib/gitlab/ci/templates/Jobs/Dependency-Scanning.gitlab-ci.yml` | CI設定 | CIテンプレート |
| base_build_action.rb | `lib/security/ci_configuration/base_build_action.rb` | ライブラリ | CI設定生成基底クラス |
| dependency_scanning_build_action.rb | `lib/security/ci_configuration/dependency_scanning_build_action.rb` | ライブラリ | 依存関係スキャン設定生成 |
| dependency_scanning_create_service.rb | `app/services/security/ci_configuration/dependency_scanning_create_service.rb` | サービス | 設定作成サービス |
| report.rb | `lib/gitlab/ci/reports/security/report.rb` | ライブラリ | セキュリティレポートクラス |
| finding.rb | `lib/gitlab/ci/reports/security/finding.rb` | ライブラリ | 検出項目クラス |
| reports.rb | `lib/gitlab/ci/config/entry/reports.rb` | エントリ | レポートエントリ定義 |
| jobs_finder.rb | `app/finders/security/jobs_finder.rb` | ファインダー | セキュリティジョブ検索 |
| security_jobs_finder.rb | `app/finders/security/security_jobs_finder.rb` | ファインダー | セキュリティジョブ検索 |
