# 機能設計書 67-シークレット検出

## 概要

本ドキュメントは、GitLabにおけるシークレット検出（Secret Detection）機能の設計仕様を記載する。ソースコード、コミット履歴、コメントなどに含まれる機密情報（APIキー、パスワード、トークン等）を自動的に検出し、漏洩リスクを軽減する機能である。

### 本機能の処理概要

シークレット検出機能は、CI/CDパイプライン内でソースコードをスキャンし、パターンマッチングにより機密情報を検出する。また、クライアントサイドでもコメント入力時等にリアルタイムで検出を行う。検出結果はセキュリティレポートとしてJSON形式で出力され、GitLab上で一元管理される。

**業務上の目的・背景**：APIキーやトークンなどの機密情報がソースコードリポジトリにコミットされることは、重大なセキュリティリスクとなる。本機能により、コードレビューやCI/CDプロセスの中で機密情報の漏洩を早期に検出し、インシデントを未然に防止する。

**機能の利用シーン**：
- コードプッシュ時のシークレットスキャン
- マージリクエストでの脆弱性レポート表示
- コメント・説明文入力時のクライアントサイド検出
- 履歴スキャンによる過去コミットのチェック
- シークレットプッシュ保護（プッシュ前ブロック）

**主要な処理内容**：
1. CI/CDパイプラインでのシークレットアナライザー実行
2. パターンマッチングによるシークレット検出
3. セキュリティレポート（JSON）の生成
4. マージリクエストでの差分表示
5. クライアントサイドでのリアルタイム検出
6. 検出シークレットのトラッキング

**関連システム・外部連携**：
- GitLab Runner（アナライザー実行）
- Gitleaks / Secrets Analyzer
- GitLabトークン検証システム

**権限による制御**：
- `read_security_configuration`権限：セキュリティ設定の閲覧
- `read_vulnerability`権限：脆弱性情報の閲覧
- `admin_vulnerability`権限：脆弱性ステータスの変更

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 125 | セキュリティ設定 | 主機能 | シークレット検出設定の管理 |

## 機能種別

セキュリティスキャン / パターンマッチング / リアルタイム検出

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SECRET_DETECTION_DISABLED | String | No | スキャン無効化フラグ | true/1で無効化 |
| SECRET_DETECTION_HISTORIC_SCAN | String | No | 履歴スキャン有効化 | true/false |
| SECRET_DETECTION_IMAGE_SUFFIX | String | No | イメージサフィックス | - |
| SECRET_DETECTION_EXCLUDED_PATHS | String | No | スキャン除外パス | - |
| SECRETS_ANALYZER_VERSION | String | No | アナライザーバージョン | デフォルト: 7 |
| SECRET_DETECTION_ENABLED | String | No | スキャン有効化フラグ | true/false |
| GIT_DEPTH | Integer | No | Git履歴の深さ | デフォルト: 50 |

### 入力データソース

- Gitリポジトリのソースコード
- コミット履歴
- ユーザー入力（コメント、説明文）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| gl-secret-detection-report.json | JSON | シークレット検出結果レポート |
| report_type | String | secret_detection |
| findings | Array | 検出されたシークレットのリスト |
| severity | String | 重大度 |
| location | Object | 検出場所（ファイルパス、行番号） |

### 出力先

- CI/CDジョブアーティファクト
- セキュリティダッシュボード
- マージリクエストウィジェット
- クライアントサイド警告ダイアログ

## 処理フロー

### 処理シーケンス

```
1. CI/CDパイプライン実行
   └─ シークレット検出ジョブ開始
   └─ アナライザーイメージ取得

2. スキャン実行
   └─ ソースコード解析
   └─ パターンマッチング
   └─ シークレット候補の抽出

3. レポート生成
   └─ gl-secret-detection-report.json作成
   └─ アーティファクトとしてアップロード

4. 結果表示
   └─ マージリクエストウィジェット
   └─ セキュリティダッシュボード

--- クライアントサイド検出 ---

5. ユーザー入力
   └─ コメント/説明文入力
   └─ リアルタイムパターンマッチング

6. 警告表示
   └─ 検出時に確認ダイアログ表示
   └─ ユーザー選択（続行/編集）
```

### フローチャート

```mermaid
flowchart TD
    subgraph "CI/CD パイプライン"
        A[パイプライン開始] --> B[シークレット検出ジョブ]
        B --> C{SECRET_DETECTION_DISABLED?}
        C -->|Yes| Z1[スキップ]
        C -->|No| D[アナライザー実行]
        D --> E[パターンマッチング]
        E --> F[レポート生成]
        F --> G[MRウィジェット表示]
    end

    subgraph "クライアントサイド"
        H[ユーザー入力] --> I[パターンチェック]
        I --> J{シークレット検出?}
        J -->|No| K[通常処理]
        J -->|Yes| L[警告ダイアログ]
        L --> M{ユーザー選択}
        M -->|続行| K
        M -->|編集| H
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | GitLabトークン検出 | glpat-, gldt-, glsoat-等のプレフィックスを持つトークンを検出 | 全スキャン |
| BR-02 | パイプライントリガートークン | glptt-プレフィックスのトークンを検出 | 全スキャン |
| BR-03 | ランナートークン | glrt-/t1_/t2_等のランナートークンを検出 | 全スキャン |
| BR-04 | OAuthシークレット | gloas-プレフィックスのOAuthシークレットを検出 | 全スキャン |
| BR-05 | フィードトークン | feed_token=/glft-プレフィックスを検出 | 全スキャン |
| BR-06 | Anthropicキー | sk-ant-プレフィックスのAPIキーを検出 | 全スキャン |
| BR-07 | アクセス制御 | アーティファクトはdeveloper以上でアクセス可能 | レポート取得時 |
| BR-08 | 履歴スキャン | SECRET_DETECTION_HISTORIC_SCANで過去コミット含む | 設定時 |

### 検出パターン一覧

| パターン名 | 正規表現パターン | 対象 |
|-----------|-----------------|------|
| GitLab PAT | `glpat-[0-9a-zA-Z_-]{20}` | Personal Access Token |
| GitLab PAT (routable) | `glpat-(?<base64>...)\.\d{2}\.(?<crc32>...)` | 新形式PAT |
| Deploy Token | `gldt-[0-9a-zA-Z_-]{20}` | Deploy Token |
| SCIM Token | `glsoat-[0-9a-zA-Z_-]{20}` | SCIM OAuth Token |
| CI Build Token | `glcbt-[0-9a-zA-Z]{1,5}_[0-9a-zA-Z_-]{20}` | Job Token |
| Feature Flags Token | `glffct-[0-9a-zA-Z_-]{20}` | Feature Flags Token |
| Runner Token | `(?:glrt-)?t\d_[0-9a-zA-Z_-]{20}` | Runner Token |
| Incoming Mail Token | `glimt-[0-9a-zA-Z_-]{25}` | Incoming Mail Token |
| K8s Agent Token | `glagent-[0-9a-zA-Z_-]{50}` | K8s Agent Token |
| Pipeline Trigger Token | `glptt-[0-9a-zA-Z_-]{40}` | Trigger Token |
| Anthropic Key | `sk-ant-[a-z]{3}\d{2}-...` | Anthropic API Key |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スキャン結果取り込み | ci_job_artifacts | INSERT | レポートファイル保存 |
| 脆弱性作成 | vulnerability_findings | INSERT | 検出項目の保存 |

### テーブル別操作詳細

#### ci_job_artifacts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | file_type | 21（secret_detection） | enum値 |
| INSERT | file_format | 3（raw） | 未圧縮 |
| INSERT | file | レポートファイル | JSON形式 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------
| - | リポジトリ空 | リポジトリにファイルがない | ファイルを追加してから実行 |
| - | アナライザーエラー | スキャン実行失敗 | ログを確認しリトライ |
| - | CI設定パースエラー | .gitlab-ci.yml解析失敗 | YAML構文を確認 |

### リトライ仕様

アナライザーエラー時、CI/CDジョブのリトライ機構を使用（allow_failure: true設定）。

## トランザクション仕様

- レポート解析とFinding作成は同一トランザクション
- 設定変更はブランチ作成とファイル更新をトランザクション化

## パフォーマンス要件

- GIT_DEPTHでスキャン対象のコミット履歴を制限（デフォルト: 50）
- SECRET_DETECTION_EXCLUDED_PATHSで除外パスを指定可能

## セキュリティ考慮事項

- 検出されたシークレットは機密性が高いため、適切なアクセス制御が必要
- アーティファクトアクセスはdeveloper以上に制限
- 検出されたトークンは即座に無効化を推奨

## 備考

- 本機能はGitLab Free以上で利用可能
- feature_category: `secret_detection`
- アナライザーはGitleaksベース
- クライアントサイド検出はリアルタイムでユーザーに警告

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とenum定義を理解する

シークレット検出で使用される主要なデータ型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | job_artifact.rb | `app/models/concerns/enums/ci/job_artifact.rb` | アーティファクト種別の定義 |
| 1-2 | security.rb | `app/models/concerns/enums/security.rb` | アナライザー種別の定義 |

**読解のコツ**:
- **job_artifact.rb 28行目**: secret_detectionのデフォルトファイル名（gl-secret-detection-report.json）
- **job_artifact.rb 78行目**: REPORT_TYPESでsecret_detection: :raw
- **job_artifact.rb 179行目**: file_typeのenum値（21）
- **security.rb 14行目**: ANALYZER_TYPES - secret_detection: 6

#### Step 2: CI/CDテンプレートを理解する

シークレット検出のCI/CD設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Secret-Detection.gitlab-ci.yml | `lib/gitlab/ci/templates/Jobs/Secret-Detection.gitlab-ci.yml` | CIテンプレート定義 |

**主要処理フロー**:
- **7-14行目**: 変数定義（SECRETS_ANALYZER_VERSION, SECRET_DETECTION_EXCLUDED_PATHS等）
- **16-29行目**: .secret-analyzerテンプレート
- **22行目**: GIT_DEPTH: "50"（履歴の深さ）
- **26行目**: access: 'developer'（アクセス制御）
- **31-51行目**: secret_detectionジョブ定義
- **34-35行目**: SECRET_DETECTION_DISABLEDでの無効化条件

#### Step 3: 設定サービスを理解する

シークレット検出設定の有効化処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | base_create_service.rb | `app/services/security/ci_configuration/base_create_service.rb` | 基底サービス |
| 3-2 | secret_detection_build_action.rb | `lib/security/ci_configuration/secret_detection_build_action.rb` | 設定生成アクション |
| 3-3 | secret_detection_create_service.rb | `app/services/security/ci_configuration/secret_detection_create_service.rb` | 設定作成サービス |

**主要処理フロー**:
- **base_create_service.rb 16-53行目**: execute - CI設定生成とブランチ作成
- **base_create_service.rb 66-80行目**: existing_gitlab_ci_content - 既存設定の読み込み
- **secret_detection_build_action.rb 17-27行目**: update_existing_content! - 設定更新
- **secret_detection_build_action.rb 56-61行目**: set_secret_detection_block - ジョブ設定生成
- **secret_detection_build_action.rb 63-65行目**: secret_detection_stage定義
- **secret_detection_build_action.rb 67-71行目**: テンプレート選択
- **secret_detection_build_action.rb 80-86行目**: 設定可能な変数一覧
- **secret_detection_create_service.rb 30-32行目**: ブランチ名定義

#### Step 4: レポート解析を理解する

スキャン結果のレポート解析処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | secret_detection.rb (parser) | `lib/gitlab/ci/parsers/security/secret_detection.rb` | パーサー |
| 4-2 | secret_detection.rb (location) | `lib/gitlab/ci/reports/security/locations/secret_detection.rb` | 位置情報クラス |

**主要処理フロー**:
- **parser 10-18行目**: create_location - 位置情報の生成
- **location 17-23行目**: コンストラクタ（file_path, start_line, end_line等）
- **location 25-27行目**: fingerprint_data - フィンガープリント生成

#### Step 5: クライアントサイド検出を理解する

ブラウザ上でのリアルタイム検出処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | secret_detection_patterns.js | `app/assets/javascripts/lib/utils/secret_detection_patterns.js` | 検出パターン定義 |
| 5-2 | secret_detection.js | `app/assets/javascripts/lib/utils/secret_detection.js` | 検出ロジック |

**主要処理フロー**:
- **secret_detection_patterns.js 5-62行目**: sensitiveDataPatterns - 検出パターン配列
- **secret_detection.js 58-79行目**: containsSensitiveToken - パターンマッチング
- **secret_detection.js 81-101行目**: confirmSensitiveAction - 確認ダイアログ
- **secret_detection.js 113-119行目**: detectAndConfirmSensitiveTokens - メイン検出関数

#### Step 6: GraphQL APIを理解する

設定変更のGraphQL APIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | configure_secret_detection.rb | `app/graphql/mutations/security/ci_configuration/configure_secret_detection.rb` | GraphQL Mutation |

**主要処理フロー**:
- **15-17行目**: configure_analyzer - SecretDetectionCreateServiceの呼び出し

### プログラム呼び出し階層図

```
CI/CD Pipeline
    │
    ├─ Secret Detection Job
    │      └─ /analyzer run (Gitleaks)
    │             └─ gl-secret-detection-report.json 生成
    │
    └─ Report Processing
           └─ Gitlab::Ci::Parsers::Security::SecretDetection
                  └─ create_location
                         └─ Locations::SecretDetection
                                │
                                ▼
                    ci_job_artifacts (secret_detection)
                           └─ vulnerability_findings テーブル

クライアントサイド
    │
    └─ secret_detection.js
           └─ containsSensitiveToken
                  └─ secret_detection_patterns.js
                         └─ confirmSensitiveAction (警告ダイアログ)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Git Repository ────▶ Secrets Analyzer ─────────────▶ gl-secret-detection-report.json
(ソースコード)          (Gitleaks)                      (CI/CD Artifact)
     │                      │                              │
     │                      ▼                              ▼
     │              Pattern Matching              MR Widget / Dashboard
     │              (正規表現照合)                  (UI表示)
     │
     └──────────▶ Client-side Detection
                  (secret_detection.js)
                          │
                          ▼
                  Warning Dialog
                  (confirmSensitiveAction)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| job_artifact.rb | `app/models/concerns/enums/ci/job_artifact.rb` | Concern | アーティファクト種別enum |
| security.rb | `app/models/concerns/enums/security.rb` | Concern | アナライザー種別enum |
| Secret-Detection.gitlab-ci.yml | `lib/gitlab/ci/templates/Jobs/Secret-Detection.gitlab-ci.yml` | CI設定 | CIテンプレート |
| base_create_service.rb | `app/services/security/ci_configuration/base_create_service.rb` | サービス | 基底サービス |
| secret_detection_build_action.rb | `lib/security/ci_configuration/secret_detection_build_action.rb` | ライブラリ | 設定生成アクション |
| secret_detection_create_service.rb | `app/services/security/ci_configuration/secret_detection_create_service.rb` | サービス | 設定作成サービス |
| secret_detection.rb (parser) | `lib/gitlab/ci/parsers/security/secret_detection.rb` | パーサー | レポート解析 |
| secret_detection.rb (location) | `lib/gitlab/ci/reports/security/locations/secret_detection.rb` | ライブラリ | 位置情報クラス |
| secret_detection_patterns.js | `app/assets/javascripts/lib/utils/secret_detection_patterns.js` | JavaScript | 検出パターン定義 |
| secret_detection.js | `app/assets/javascripts/lib/utils/secret_detection.js` | JavaScript | クライアント検出ロジック |
| configure_secret_detection.rb | `app/graphql/mutations/security/ci_configuration/configure_secret_detection.rb` | GraphQL | 設定Mutation |
