# 機能設計書 76-ユーザー登録

## 概要

本ドキュメントは、GitLabのユーザー登録機能について、その処理概要、入出力仕様、処理フロー、データベース操作仕様を定義する。

### 本機能の処理概要

ユーザー登録機能は、新規ユーザーアカウントを作成するための機能である。メールアドレスとパスワードによる登録、メール確認、利用規約への同意、管理者承認フローなど、セキュリティとコンプライアンスを考慮した登録プロセスを提供する。

**業務上の目的・背景**：GitLabを利用するためにはユーザーアカウントが必要である。ユーザー登録機能は、新規ユーザーがセルフサービスでアカウントを作成できるようにし、同時にスパム登録の防止、メールアドレスの確認、必要に応じた管理者承認など、セキュリティ要件を満たす登録プロセスを実現する。

**機能の利用シーン**：
- 新規ユーザーがGitLabアカウントを作成する場合
- 招待メールからアカウントを作成する場合
- OAuth認証後にアカウントを作成する場合
- 管理者承認が必要な環境での登録申請

**主要な処理内容**：
1. ユーザー情報の入力（ユーザー名、メールアドレス、パスワード、氏名）
2. reCAPTCHAによるスパム防止チェック
3. ユーザーレコードの作成
4. 確認メールの送信（設定による）
5. 招待の受け入れ処理
6. 利用規約への同意記録
7. システムフックの実行
8. 管理者承認待ち状態への移行（設定による）
9. アカウント削除

**関連システム・外部連携**：
- reCAPTCHA（スパム防止）
- メール送信システム（確認メール）
- システムフック（ユーザー作成イベント）
- 組織（Organization）への紐付け
- 身元確認（Identity Verification）

**権限による制御**：
- 登録: サインアップが有効な場合、誰でも登録可能
- 管理者承認: システム設定で管理者承認が必要な場合、承認まで利用不可
- アカウント削除: 本人のみ（所有グループの移譲が必要）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ログイン画面 | 遷移元画面 | ユーザー認証・ログイン処理の実行 |
| 4 | ユーザー登録画面 | 主画面 | 新規ユーザーアカウントの作成処理 |
| 5 | アカウントロック解除画面 | 関連画面 | ロックされたアカウントの解除要求処理 |
| 200 | アクティブセッション一覧 | 参照画面 | アクティブセッションの管理 |
| 216 | 利用規約 | 関連画面 | 利用規約の承認 |

## 機能種別

CRUD操作 / 認証処理 / 外部連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| username | String | Yes | ユーザー名 | 2-255文字、英数字・ハイフン・アンダースコア |
| email | String | Yes | メールアドレス | 有効なメール形式 |
| password | String | Yes | パスワード | 最小長（設定による）、強度チェック |
| first_name | String | Yes | 名 | 空でないこと |
| last_name | String | Yes | 姓 | 空でないこと |
| name | String | No | フルネーム | first_name + last_nameから生成可能 |

### 入力データソース

- 画面入力（登録フォーム）
- 招待メールからのパラメータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| id | Integer | ユーザーID |
| username | String | ユーザー名 |
| email | String | メールアドレス |
| name | String | フルネーム |
| state | String | アカウント状態 |
| confirmed | Boolean | メール確認済みか |
| created_at | DateTime | 作成日時 |

### 出力先

- 画面表示（リダイレクト）
- ユーザーセッション
- 確認メール送信

## 処理フロー

### 処理シーケンス

```
1. サインアップ有効確認
   └─ システム設定でサインアップが有効か確認
2. reCAPTCHA検証
   └─ スパム防止チェック
3. 入力バリデーション
   └─ ユーザー名、メール、パスワード等の検証
4. ユーザーレコード作成
   └─ Deviseを使用したユーザー作成
5. 招待受け入れ
   └─ 招待経由の場合、メンバーシップ設定
6. 利用規約同意
   └─ 有効な場合、同意を記録
7. システムフック実行
   └─ ユーザー作成イベントを通知
8. 承認待ち通知
   └─ 管理者承認が必要な場合、通知送信
9. 確認メール送信
   └─ メール確認が必要な場合、送信
10. リダイレクト
    └─ 適切な次画面へ遷移
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{サインアップ有効?}
    B -->|No| C[ログイン画面へリダイレクト]
    B -->|Yes| D{reCAPTCHA検証}
    D -->|失敗| E[エラー表示・再入力]
    D -->|成功| F{first_name/last_name確認}
    F -->|空| E
    F -->|OK| G[ユーザーレコード作成]
    G --> H{作成成功?}
    H -->|No| I[エラー表示]
    H -->|Yes| J[招待受け入れ]
    J --> K[利用規約同意記録]
    K --> L[システムフック実行]
    L --> M{管理者承認必要?}
    M -->|Yes| N[承認待ち通知]
    N --> O[ログイン画面へ]
    M -->|No| P{メール確認必要?}
    P -->|Yes| Q[確認メール送信]
    Q --> R[確認待ち画面へ]
    P -->|No| S[ダッシュボードへ]
    O --> T[終了]
    R --> T
    S --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-01 | サインアップ有効確認 | signup_enabledが無効の場合は登録不可 | 登録開始時 |
| BR-76-02 | reCAPTCHA必須 | 設定で有効な場合、reCAPTCHA検証必須 | 登録送信時 |
| BR-76-03 | 氏名必須 | first_nameとlast_nameは空不可 | 登録送信時 |
| BR-76-04 | 招待メール一致 | 招待メールと登録メールが一致すれば確認スキップ | 招待経由登録時 |
| BR-76-05 | 管理者承認 | require_admin_approval_after_user_signupが有効な場合、承認待ち状態 | 登録完了時 |
| BR-76-06 | レート制限 | user_sign_upレート制限が適用される | 登録送信時 |
| BR-76-07 | 削除時グループ確認 | 単独所有グループがある場合は削除不可 | アカウント削除時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ユーザー作成 | users | INSERT | ユーザーレコード作成 |
| 利用規約同意 | term_agreements | INSERT | 同意記録 |
| 招待受け入れ | members | UPDATE | メンバーシップ更新 |
| アカウント削除 | users | UPDATE/DELETE | 非同期削除 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | username | ユーザー入力値 | 必須、一意 |
| INSERT | email | ユーザー入力値 | 必須、一意 |
| INSERT | encrypted_password | 暗号化されたパスワード | Deviseで暗号化 |
| INSERT | name | ユーザー入力値 | first_name + last_name |
| INSERT | first_name | ユーザー入力値 | 必須 |
| INSERT | last_name | ユーザー入力値 | 必須 |
| INSERT | state | 'blocked_pending_approval'または'active' | 設定による |
| INSERT | organization_id | 初期組織ID | デフォルト組織 |
| INSERT | preferred_language | ユーザー選択または設定デフォルト | 言語設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | サインアップ無効 | signup_enabledがfalse | ログイン画面へリダイレクト |
| - | reCAPTCHA失敗 | reCAPTCHA検証失敗 | エラーメッセージ表示、再試行 |
| - | バリデーションエラー | 入力値不正 | エラー内容を表示 |
| - | レート制限 | 登録試行過多 | 待機を促すメッセージ |
| - | 削除時グループエラー | 単独所有グループあり | グループ移譲を促す |

### リトライ仕様

特になし

## トランザクション仕様

- ユーザー作成はDeviseのトランザクション内で実行
- 関連処理（フック、通知）はafter_commitで実行

## パフォーマンス要件

- 登録処理: 3秒以内のレスポンス
- レート制限: IPアドレスベースで制限

## セキュリティ考慮事項

- reCAPTCHAによるボット防止
- パスワード強度チェック
- 弱いパスワードエラーのトラッキング
- レート制限によるブルートフォース防止
- メール確認による本人確認
- 管理者承認オプション
- CSRF対策

## 備考

- Deviseを使用した認証基盤
- Invisible CAPTCHAもサポート
- 身元確認（Identity Verification）機能はEE版で利用可能
- アカウント削除は非同期処理（delete_async）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Userモデルの属性、バリデーション、Devise設定を確認 |

**読解のコツ**:
- **112-120行目**: Devise設定（two_factor_authenticatable, lockable, recoverable等）
- **53行目**: BLOCKED_PENDING_APPROVAL_STATE定数
- 多くのconcernをincludeしているため、関連ファイルも参照

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | registrations_controller.rb | `app/controllers/registrations_controller.rb` | 登録コントローラーの構造を確認 |

**主要処理フロー**:
1. **19-20行目**: `check_captcha`でreCAPTCHA検証
2. **21行目**: `ensure_first_name_and_last_name_not_empty`で氏名確認
3. **26-27行目**: レート制限チェック
4. **29行目**: `ensure_signup_enabled`でサインアップ有効確認
5. **40-59行目**: `create`アクションでユーザー作成
6. **61-75行目**: `destroy`アクションでアカウント削除

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | registrations_build_service.rb | `app/services/users/registrations_build_service.rb` | ユーザー構築サービス（存在する場合） |

**主要処理フロー（registrations_controller.rb）**:
- **107-113行目**: `after_successful_create_hook`で後処理（招待受け入れ、利用規約、フック実行）
- **286-291行目**: `resource`メソッドでUsers::RegistrationsBuildServiceを使用
- **313-317行目**: `set_resource_fields`で承認待ち状態設定

### プログラム呼び出し階層図

```
RegistrationsController
    │
    ├─ new
    │      └─ build_resource
    │
    └─ create
           │
           ├─ check_captcha
           │      └─ verify_recaptcha
           │
           ├─ ensure_first_name_and_last_name_not_empty
           │
           ├─ Devise::RegistrationsController#create
           │      └─ Users::RegistrationsBuildService
           │
           └─ after_successful_create_hook
                  ├─ accept_pending_invitations
                  ├─ persist_accepted_terms_if_required
                  ├─ execute_system_hooks
                  │      └─ SystemHooksService
                  ├─ notify_new_instance_access_request
                  │      └─ NotificationService
                  └─ track_successful_user_creation
```

### データフロー図

```
[入力]               [処理]                    [出力]

登録フォーム ───▶ RegistrationsController ───▶ リダイレクト
    │                    │
    │                    ├─▶ reCAPTCHA検証
    │                    │
    │                    ├─▶ RegistrationsBuildService
    │                    │         │
    │                    │         └─▶ User.create
    │                    │
    │                    ├─▶ SystemHooksService
    │                    │
    │                    ├─▶ NotificationService
    │                    │
    │                    └─▶ 確認メール送信
    │
    └── params[:user]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| registrations_controller.rb | `app/controllers/registrations_controller.rb` | コントローラー | 登録処理のルーティング |
| user.rb | `app/models/user.rb` | モデル | ユーザーのデータ構造定義 |
| registrations_build_service.rb | `app/services/users/registrations_build_service.rb` | サービス | ユーザー構築処理 |
| system_hooks_service.rb | `app/services/system_hooks_service.rb` | サービス | システムフック実行 |
| notification_service.rb | `app/services/notification_service.rb` | サービス | 通知送信 |
| recaptcha_helper.rb | `app/helpers/recaptcha_helper.rb` | ヘルパー | reCAPTCHA関連 |
