# 機能設計書 78-パスワード管理

## 概要

本ドキュメントは、GitLabのパスワード管理機能について、その処理概要、入出力仕様、処理フロー、データベース操作仕様を定義する。

### 本機能の処理概要

パスワード管理機能は、ユーザーのパスワードの変更・リセットを行う機能である。パスワード忘れ時のリセット、パスワード変更、パスワード有効期限管理などを提供する。

**業務上の目的・背景**：セキュリティの観点から、ユーザーは定期的にパスワードを変更する必要がある。また、パスワードを忘れた場合には、安全にリセットする手段を提供する必要がある。パスワード管理機能は、これらのニーズに対応し、ユーザーが安全にアカウントにアクセスできるようにする。

**機能の利用シーン**：
- ユーザーがパスワードを忘れた場合のリセット
- ユーザーがパスワードを変更する場合
- パスワード有効期限切れ時の強制変更
- 管理者からのパスワードリセット要求

**主要な処理内容**：
1. パスワードリセット要求（メールアドレス入力）
2. リセット用メール送信
3. リセットトークンの検証
4. 新しいパスワードの設定
5. パスワード変更

**関連システム・外部連携**：
- メール送信システム（リセットメール）
- reCAPTCHA（スパム防止）
- 監査ログ（失敗記録）

**権限による制御**：
- パスワードリセット要求: 誰でも可能
- パスワード変更: 本人のみ

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | パスワードリセット画面 | 主画面 | パスワードリセット要求の送信処理 |
| 3 | パスワード変更画面 | 入力画面 | 新しいパスワードの設定処理 |
| 196 | パスワード変更 | 入力画面 | パスワードの変更 |
| 197 | パスワード新規設定 | 入力画面 | 初回パスワードの設定 |

## 機能種別

認証処理 / セキュリティ機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| email | String | Yes（リセット要求時） | メールアドレス | 有効なメール形式 |
| reset_password_token | String | Yes（リセット実行時） | リセットトークン | 有効なトークン |
| password | String | Yes（変更時） | 新しいパスワード | 最小長、強度チェック |
| password_confirmation | String | Yes（変更時） | パスワード確認 | passwordと一致 |

### 入力データソース

- 画面入力（リセット要求フォーム、パスワード変更フォーム）
- リセットメール内のリンク

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| success | Boolean | 処理成功/失敗 |
| message | String | 結果メッセージ |

### 出力先

- 画面表示（リダイレクト、メッセージ）
- リセットメール送信

## 処理フロー

### 処理シーケンス

```
【パスワードリセット要求】
1. reCAPTCHA検証
   └─ スパム防止チェック
2. メールアドレス存在確認
   └─ ユーザー検索
3. パスワード認証可能確認
   └─ パスワード認証が有効か確認
4. スロットリングチェック
   └─ 最近のリセット要求確認
5. リセットトークン生成
   └─ Deviseでトークン生成
6. リセットメール送信
   └─ 非同期でメール送信

【パスワードリセット実行】
1. トークン検証
   └─ トークンの有効性確認
2. 有効期限確認
   └─ トークンの期限切れ確認
3. パスワードバリデーション
   └─ 強度チェック
4. パスワード更新
   └─ 暗号化して保存
5. 関連フラグのクリア
   └─ password_automatically_set, password_expires_at
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|リセット要求| C{reCAPTCHA検証}
    C -->|失敗| D[エラー表示]
    C -->|成功| E{パスワード認証可能?}
    E -->|No| F[認証不可メッセージ]
    E -->|Yes| G{スロットリング?}
    G -->|Yes| H[待機メッセージ]
    G -->|No| I[リセットトークン生成]
    I --> J[リセットメール送信]
    J --> K[確認メッセージ]
    B -->|リセット実行| L{トークン有効?}
    L -->|No| M[期限切れエラー]
    L -->|Yes| N{パスワード検証}
    N -->|失敗| O[エラー表示]
    N -->|成功| P[パスワード更新]
    P --> Q[ログイン画面へ]
    D --> R[終了]
    F --> R
    H --> R
    K --> R
    M --> R
    O --> R
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-01 | パスワード認証必須 | パスワード認証が無効な場合はリセット不可 | リセット要求時 |
| BR-78-02 | スロットリング | 最近リセット要求があった場合は拒否 | リセット要求時 |
| BR-78-03 | トークン有効期限 | リセットトークンには有効期限がある | リセット実行時 |
| BR-78-04 | フラグクリア | リセット成功時、password_automatically_setとpassword_expires_atをクリア | リセット実行時 |
| BR-78-05 | 弱いパスワード追跡 | 弱いパスワードエラーをトラッキング | パスワード設定時 |
| BR-78-06 | ユーザー列挙防止 | メールが存在しなくても同じメッセージを返す | リセット要求時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リセットトークン生成 | users | UPDATE | reset_password_token, reset_password_sent_at |
| パスワード更新 | users | UPDATE | encrypted_password, password_automatically_set, password_expires_at |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | reset_password_token | Deviseが生成したハッシュ | リセット要求時 |
| UPDATE | reset_password_sent_at | 現在日時 | リセット要求時 |
| UPDATE | encrypted_password | 暗号化されたパスワード | パスワード更新時 |
| UPDATE | password_automatically_set | false | パスワード更新時 |
| UPDATE | password_expires_at | nil | パスワード更新時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | reCAPTCHA失敗 | reCAPTCHA検証失敗 | エラーメッセージ表示、再試行 |
| - | 認証不可 | パスワード認証が無効 | 認証不可メッセージ表示 |
| - | スロットリング | 最近リセット要求あり | 待機を促すメッセージ |
| - | トークン期限切れ | リセットトークン期限切れ | 新規リセット要求を促す |
| - | バリデーションエラー | パスワード強度不足 | エラー内容を表示 |

### リトライ仕様

スロットリングにより、短時間での連続リセット要求は制限される。

## トランザクション仕様

- パスワード更新はDeviseのトランザクション内で実行

## パフォーマンス要件

- リセット要求: 即時応答（ただしメール送信は非同期）
- パスワード更新: 2秒以内

## セキュリティ考慮事項

- reCAPTCHAによるスパム防止
- スロットリングによるブルートフォース防止
- ユーザー列挙攻撃への対策（同一メッセージ）
- トークン有効期限
- 弱いパスワードの追跡・ログ
- 監査ログ（リセット失敗の記録）

## 備考

- Devise::PasswordsControllerを継承
- EE版では監査ログへの失敗記録機能あり
- paranoid_instructionsメッセージでユーザー列挙を防止

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Deviseのrecoverableモジュールを確認 |

**読解のコツ**:
- `devise :recoverable`の設定を確認
- reset_password_token, reset_password_sent_atカラムの使用を確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/passwords_controller.rb` | パスワードコントローラーの構造を確認 |

**主要処理フロー**:
1. **7行目**: `skip_before_action :require_no_authentication`でログイン済みでもedit/updateを許可
2. **9行目**: `check_recaptcha`でreCAPTCHA検証
3. **12行目**: `check_password_authentication_available`でパスワード認証可能確認
4. **13行目**: `throttle_reset`でスロットリング
5. **18-37行目**: `edit`アクションでトークン検証
6. **40-51行目**: `update`アクションでパスワード更新
7. **43-45行目**: password_automatically_set, password_expires_atのクリア

#### Step 3: 関連処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gitlab_recaptcha.rb | `app/controllers/concerns/gitlab_recaptcha.rb` | reCAPTCHA処理 |

### プログラム呼び出し階層図

```
PasswordsController
    │
    ├─ new（リセット要求フォーム表示）
    │
    ├─ create（リセット要求処理）
    │      ├─ check_recaptcha
    │      ├─ resource_from_email
    │      ├─ check_password_authentication_available
    │      ├─ throttle_reset
    │      └─ Devise::PasswordsController#create
    │             └─ リセットメール送信
    │
    ├─ edit（パスワード変更フォーム表示）
    │      └─ トークン有効期限確認
    │
    └─ update（パスワード更新）
           ├─ Devise::PasswordsController#update
           │      └─ パスワード検証・更新
           ├─ password_automatically_set = false
           ├─ password_expires_at = nil
           └─ log_audit_reset_failure（失敗時）
```

### データフロー図

```
[入力]               [処理]                    [出力]

リセット要求 ───▶ PasswordsController ───▶ 確認メッセージ
    │                    │
    │                    ├─▶ reCAPTCHA検証
    │                    │
    │                    ├─▶ スロットリング確認
    │                    │
    │                    └─▶ Devise::Recoverable
    │                              │
    │                              └─▶ リセットメール送信

パスワード更新 ───▶ PasswordsController ───▶ ログイン画面
    │                    │
    │                    ├─▶ トークン検証
    │                    │
    │                    └─▶ パスワード更新
    │                              │
    │                              └─▶ usersテーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/passwords_controller.rb` | コントローラー | パスワード管理処理 |
| gitlab_recaptcha.rb | `app/controllers/concerns/gitlab_recaptcha.rb` | コンサーン | reCAPTCHA処理 |
| user.rb | `app/models/user.rb` | モデル | Deviseのrecoverable設定 |
| weak_password_error_event.rb | `lib/gitlab/tracking/helpers/weak_password_error_event.rb` | ヘルパー | 弱いパスワードエラー追跡 |
