# 機能設計書 79-2要素認証

## 概要

本ドキュメントは、GitLabの2要素認証（Two-Factor Authentication, 2FA）機能について、その処理概要、入出力仕様、処理フロー、データベース操作仕様を定義する。

### 本機能の処理概要

2要素認証機能は、ユーザーアカウントのセキュリティを強化するため、パスワードに加えて第二の認証要素を設定・管理する機能である。TOTP（Time-based One-Time Password）とWebAuthn（セキュリティキー）の2種類の認証方式をサポートする。

**業務上の目的・背景**：パスワードのみの認証では、パスワード漏洩時にアカウントが乗っ取られるリスクがある。2要素認証を導入することで、パスワードが漏洩しても第二の認証要素がなければログインできないため、アカウントのセキュリティが大幅に向上する。組織やグループの設定により、2FAを必須にすることも可能である。

**機能の利用シーン**：
- ユーザーが2FAを有効化する場合
- セキュリティキー（WebAuthn）を登録する場合
- バックアップコードを再生成する場合
- 2FAを無効化する場合
- グループや管理者の要件により2FAの設定を求められた場合

**主要な処理内容**：
1. TOTP（ワンタイムパスワード）デバイスの登録
2. WebAuthn（セキュリティキー）デバイスの登録
3. バックアップコードの生成
4. 2FAの無効化
5. 個別デバイスの削除（OTP、WebAuthn）
6. 2FA設定のスキップ（猶予期間内）

**関連システム・外部連携**：
- QRコード生成（RQRCode）
- WebAuthn認証（FIDO2）
- 通知サービス（2FA有効化/無効化通知）

**権限による制御**：
- 2FA設定: 本人のみ
- 2FA無効化: 本人または管理者

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 193 | 2要素認証設定 | 主画面 | 2FA設定画面の表示、OTP/WebAuthn登録 |
| 194 | WebAuthnデバイス一覧 | 参照画面 | 登録済みWebAuthnデバイスの管理 |
| 195 | バックアップコード | 結果表示画面 | バックアップコードの表示・再生成 |

## 機能種別

認証処理 / セキュリティ機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pin_code | String | Yes（OTP登録時） | 6桁のワンタイムパスワード | 6桁数字 |
| current_password | String | Yes（パスワード必須時） | 現在のパスワード | 正しいパスワード |
| device_registration.name | String | Yes（WebAuthn登録時） | デバイス名 | - |
| device_registration.device_response | String | Yes（WebAuthn登録時） | WebAuthn認証レスポンス | 有効なJSON |

### 入力データソース

- 画面入力（2FA設定フォーム）
- WebAuthn認証デバイス
- 認証アプリ（Google Authenticator等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| qr_code | String | QRコード（SVG形式） |
| account_string | String | TOTP用アカウント文字列 |
| codes | Array | バックアップコード（10個） |
| registrations | Array | WebAuthn登録一覧 |
| passkeys | Array | パスキー一覧 |

### 出力先

- 画面表示（QRコード、バックアップコード）
- 通知メール（2FA有効化/無効化時）

## 処理フロー

### 処理シーケンス

```
【TOTP登録】
1. メール検証確認
   └─ プライマリメールが検証済みか確認
2. OTPシークレット生成
   └─ 未設定の場合、新しいシークレットを生成
3. QRコード表示
   └─ OTPプロビジョニングURIからQRコード生成
4. PINコード検証
   └─ ValidateManualOtpServiceで検証
5. 2FA有効化
   └─ otp_required_for_login = true
6. バックアップコード生成
   └─ 初回のみ10個のコードを生成

【WebAuthn登録】
1. パスワード確認
   └─ 現在のパスワードを検証
2. WebAuthnオプション生成
   └─ challenge等を含むオプションを生成
3. デバイス応答検証
   └─ WebAuthn::Credential.from_createで検証
4. 登録情報保存
   └─ WebauthnRegistrationレコードを作成
5. バックアップコード生成
   └─ 未生成の場合のみ

【2FA無効化】
1. 権限確認
   └─ can?(:disable_two_factor, user)
2. 2FA無効化
   └─ user.disable_two_factor!
3. 通知送信
   └─ notification_service.disabled_two_factor
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{操作種別}
    B -->|TOTP登録| C{メール検証済み?}
    C -->|No| D[メール検証画面へ]
    C -->|Yes| E{パスワード確認}
    E -->|失敗| F[エラー表示]
    E -->|成功| G[QRコード表示]
    G --> H{PINコード入力}
    H -->|失敗| I[エラー表示]
    H -->|成功| J{バックアップコード存在?}
    J -->|Yes| K[2FA有効化]
    J -->|No| L[バックアップコード生成]
    L --> K
    K --> M[完了]
    B -->|WebAuthn登録| N{パスワード確認}
    N -->|失敗| F
    N -->|成功| O[WebAuthnオプション生成]
    O --> P{デバイス認証}
    P -->|失敗| Q[エラー表示]
    P -->|成功| R[登録情報保存]
    R --> S{バックアップコード存在?}
    S -->|Yes| M
    S -->|No| L
    B -->|2FA無効化| T{権限確認}
    T -->|No| U[権限エラー]
    T -->|Yes| V[2FA無効化]
    V --> W[通知送信]
    W --> M
    D --> X[終了]
    F --> X
    I --> X
    Q --> X
    U --> X
    M --> X
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-79-01 | メール検証必須 | プライマリメールが未検証の場合は2FA登録不可 | 2FA登録時 |
| BR-79-02 | パスワード確認 | 一部操作では現在のパスワードの入力が必要 | 登録・削除操作時 |
| BR-79-03 | セッション破棄 | 2FA有効化時、現在以外のセッションを破棄 | TOTP登録成功時 |
| BR-79-04 | バックアップコード | 初回2FA有効化時にバックアップコードを生成 | 初回登録時 |
| BR-79-05 | 猶予期間 | グループ設定で2FAに猶予期間を設けられる | 2FA必須グループ所属時 |
| BR-79-06 | グループ要件 | グループ設定で2FAを必須にできる | グループ所属時 |
| BR-79-07 | 管理者要件 | 管理者は2FAを必須に設定可能 | 管理者ユーザー |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| TOTP登録 | users | UPDATE | otp_required_for_login, otp_backup_codes等 |
| WebAuthn登録 | webauthn_registrations | INSERT | WebAuthn認証情報 |
| WebAuthn登録 | user_details | UPDATE | webauthn_xid |
| バックアップコード生成 | users | UPDATE | otp_backup_codes |
| 2FA無効化 | users | UPDATE | otp_required_for_login等をクリア |
| WebAuthn削除 | webauthn_registrations | DELETE | 登録情報削除 |

### テーブル別操作詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | otp_secret | 生成されたシークレット | TOTP用 |
| UPDATE | otp_required_for_login | true/false | 2FA有効/無効 |
| UPDATE | otp_backup_codes | 暗号化されたコード配列 | 10個のバックアップコード |
| UPDATE | otp_grace_period_started_at | 現在日時 | 猶予期間開始 |

#### webauthn_registrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | credential_xid | Base64エンコードされたID | WebAuthn識別子 |
| INSERT | public_key | 公開鍵 | 認証用 |
| INSERT | counter | 署名カウンター | リプレイ攻撃防止 |
| INSERT | name | ユーザー入力値 | デバイス名 |
| INSERT | authentication_mode | 1 or 2 | passwordless or second_factor |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メール未検証 | プライマリメールが未検証 | メール検証画面へリダイレクト |
| - | パスワードエラー | 現在のパスワードが不正 | エラーメッセージ表示、失敗回数増加 |
| - | PINコードエラー | OTPコードが不正 | エラーメッセージ表示 |
| - | WebAuthnエラー | デバイス認証失敗 | エラーメッセージ表示 |
| - | 権限エラー | 2FA無効化の権限なし | エラーメッセージ表示 |
| - | 猶予期間切れ | 2FAスキップ不可 | エラーメッセージ表示 |

### リトライ仕様

- パスワード検証失敗時、failed_attemptsがインクリメントされる
- 一定回数失敗でアカウントロック

## トランザクション仕様

- WebAuthn登録はWebauthn::RegisterService内でトランザクション管理
- 2FA無効化はUsers::UpdateService内でトランザクション管理

## パフォーマンス要件

- QRコード生成: 1秒以内
- 2FA登録: 2秒以内
- WebAuthn認証: デバイス応答依存

## セキュリティ考慮事項

- OTPシークレットは暗号化して保存
- バックアップコードは暗号化して保存
- パスワード確認による本人確認
- セッション破棄による不正アクセス防止
- WebAuthnのカウンターによるリプレイ攻撃防止
- 通知メールによる変更検知

## 備考

- Profiles::TwoFactorAuthsControllerで処理
- WebAuthn登録はWebauthn::RegisterServiceで処理
- 2FA無効化はTwoFactor::DestroyServiceで処理
- EE版では追加のセキュリティ機能あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | 2FA関連の属性とメソッドを確認 |
| 1-2 | webauthn_registration.rb | `app/models/webauthn_registration.rb` | WebAuthn登録情報の構造を確認 |

**読解のコツ**:
- otp_secret, otp_required_for_login, otp_backup_codesの属性を確認
- authentication_mode列挙型（passwordless, second_factor）を確認

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | two_factor_auths_controller.rb | `app/controllers/profiles/two_factor_auths_controller.rb` | 2FAコントローラーの構造を確認 |

**主要処理フロー**:
1. **5行目**: `ensure_verified_primary_email`でメール検証確認
2. **6-8行目**: `validate_current_password`でパスワード確認
3. **24-53行目**: `create`アクションでTOTP登録
4. **55-89行目**: `create_webauthn`アクションでWebAuthn登録
5. **91-97行目**: `codes`アクションでバックアップコード再生成
6. **99-109行目**: `destroy`アクションで2FA完全無効化
7. **173-187行目**: `build_qr_code`でQRコード生成
8. **201-212行目**: `setup_webauthn_registration`でWebAuthn設定準備

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | register_service.rb | `app/services/webauthn/register_service.rb` | WebAuthn登録処理 |
| 3-2 | destroy_service.rb | `app/services/two_factor/destroy_service.rb` | 2FA無効化処理 |

### プログラム呼び出し階層図

```
Profiles::TwoFactorAuthsController
    │
    ├─ show（2FA設定画面）
    │      ├─ update_current_user_otp!
    │      │      └─ current_user.update_otp_secret!
    │      ├─ build_qr_code
    │      │      └─ RQRCode::QRCode.new
    │      └─ setup_webauthn_registration
    │             └─ WebAuthn::Credential.options_for_create
    │
    ├─ create（TOTP登録）
    │      ├─ Users::ValidateManualOtpService
    │      ├─ destroy_all_but_current_user_session!
    │      ├─ Users::UpdateService
    │      │      └─ otp_required_for_login = true
    │      └─ user.generate_otp_backup_codes!
    │
    ├─ create_webauthn（WebAuthn登録）
    │      └─ Webauthn::RegisterService
    │             └─ WebAuthn::Credential.from_create
    │                    └─ webauthn_credential.verify
    │
    ├─ codes（バックアップコード再生成）
    │      └─ user.generate_otp_backup_codes!
    │
    ├─ destroy（2FA完全無効化）
    │      └─ TwoFactor::DestroyService
    │             └─ user.disable_two_factor!
    │
    ├─ destroy_otp（OTP削除）
    │      └─ TwoFactor::DestroyOtpService
    │
    └─ destroy_webauthn（WebAuthn削除）
           └─ Webauthn::DestroyService
```

### データフロー図

```
[入力]               [処理]                           [出力]

TOTP設定 ─────────▶ TwoFactorAuthsController ─────▶ QRコード表示
    │                      │
    │                      ├─▶ OTPシークレット生成
    │                      │
    │                      └─▶ QRコード生成
    │
PINコード入力 ────▶ TwoFactorAuthsController ─────▶ バックアップコード
    │                      │
    │                      ├─▶ ValidateManualOtpService
    │                      │
    │                      └─▶ Users::UpdateService
    │                               │
    │                               └─▶ usersテーブル

WebAuthn登録 ────▶ TwoFactorAuthsController ─────▶ 登録完了
    │                      │
    │                      └─▶ Webauthn::RegisterService
    │                               │
    │                               └─▶ webauthn_registrations
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| two_factor_auths_controller.rb | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | 2FA管理処理 |
| webauthn_registration.rb | `app/models/webauthn_registration.rb` | モデル | WebAuthn登録データ構造 |
| register_service.rb | `app/services/webauthn/register_service.rb` | サービス | WebAuthn登録処理 |
| destroy_service.rb | `app/services/two_factor/destroy_service.rb` | サービス | 2FA無効化処理 |
| destroy_otp_service.rb | `app/services/two_factor/destroy_otp_service.rb` | サービス | OTP削除処理 |
| destroy_service.rb | `app/services/webauthn/destroy_service.rb` | サービス | WebAuthn削除処理 |
| validate_manual_otp_service.rb | `app/services/users/validate_manual_otp_service.rb` | サービス | OTP検証処理 |
