# 機能設計書 96-Jira連携

## 概要

本ドキュメントは、GitLabにおけるJira連携機能の設計仕様を記載する。本機能は、GitLabとJiraを連携させ、Jiraイシューの参照、コミット/MRからのJiraイシュークローズ、クロスリファレンスコメントの作成などを実現する。

### 本機能の処理概要

Jira連携機能は、GitLabのコミットやマージリクエストからJiraイシューを参照・更新する双方向連携を提供する。コミットメッセージやMR内でJiraイシューキーを記載すると、自動的にJiraにリンクが作成され、イシューの状態を自動的に遷移させることも可能。

**業務上の目的・背景**：多くの組織ではJiraをプロジェクト管理・イシュートラッキングに使用しながら、GitLabでソースコード管理を行っている。両ツールを連携させることで、開発作業とイシュー管理の紐づけが自動化され、トレーサビリティが向上する。

**機能の利用シーン**：本機能は以下のシーンで利用される。
- コミットメッセージにJiraイシューキーを記載してイシューをリンク
- MRマージ時にJiraイシューを自動クローズ
- GitLabからJiraイシューを閲覧（Premium機能）
- 脆弱性からJiraイシューを作成（Ultimate機能）

**主要な処理内容**：
1. Jira API接続設定（URL、認証情報）
2. Jiraイシューキーのパターンマッチング
3. コミット/MR内のJiraイシュー参照検出
4. Jiraへのリモートリンク作成
5. Jiraへのコメント投稿
6. Jiraイシューのステータス遷移

**関連システム・外部連携**：Jira Cloud、Jira Data Center、Jira Server

**権限による制御**：プロジェクト/グループのMaintainer以上が設定可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 142 | インテグレーション設定 | 主機能 | Jira連携の設定 |

## 機能種別

インテグレーション / 外部イシュートラッカー連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | String | Yes | Jira Web URL | パブリックURL |
| api_url | String | No | Jira API URL（Web URLと異なる場合） | パブリックURL |
| jira_auth_type | Integer | Yes | 認証タイプ（0: Basic、1: PAT） | 0または1 |
| username | String | Conditional | メールアドレスまたはユーザー名 | Basic認証時必須 |
| password | String | Yes | APIトークン、パスワード、またはPAT | - |
| jira_issue_regex | String | No | Jiraイシューキー正規表現 | RE2構文、255文字以内 |
| jira_issue_prefix | String | No | Jiraイシューキープレフィックス | 255文字以内 |
| jira_issue_transition_id | String | No | イシュー遷移ID（カンマ/セミコロン区切り） | 数値リスト形式 |
| jira_issue_transition_automatic | Boolean | No | 自動遷移を有効化 | - |
| issues_enabled | Boolean | No | Jiraイシュー表示を有効化（Premium） | - |
| project_keys | Array | No | 表示するJiraプロジェクトキー | - |
| comment_on_event_enabled | Boolean | No | イベント時にコメント投稿 | - |
| commit_events | Boolean | No | コミットイベントを有効化 | - |
| merge_requests_events | Boolean | No | MRイベントを有効化 | - |

### 入力データソース

- 画面入力（プロジェクト/グループ設定 > インテグレーション > Jira）
- REST API
- コミットメッセージ、MRタイトル/説明

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Jiraイシュー情報 | Object | イシュー詳細、ステータス等 |
| リモートリンク | Object | GitLab参照リンク |
| コメント | String | クロスリファレンスコメント |

### 出力先

- Jira API（リモートリンク、コメント、遷移）
- GitLab画面（Jiraイシュー一覧 - Premium）

## 処理フロー

### 処理シーケンス

```
1. イベント発生
   └─ コミットまたはMRでJiraイシューキーが検出される

2. Jiraイシュー参照
   └─ Jira APIでイシュー情報を取得

3. リモートリンク作成
   └─ GitLab側の参照元URLをJiraにリンク

4. コメント投稿（有効時）
   └─ クロスリファレンスコメントをJiraイシューに投稿

5. ステータス遷移（有効時）
   └─ MRマージ時にJiraイシューをDone状態に遷移

6. 使用状況ログ
   └─ HLLカウンター、Snowplow追跡
```

### フローチャート

```mermaid
flowchart TD
    A[コミット/MR作成] --> B{Jira連携有効?}
    B -->|No| C[終了]
    B -->|Yes| D[Jiraイシューキー検出]
    D --> E{イシュー存在?}
    E -->|No| C
    E -->|Yes| F[リモートリンク確認]
    F --> G{リンク存在?}
    G -->|Yes| H[スキップ]
    G -->|No| I{コメント有効?}
    I -->|Yes| J[コメント投稿]
    I -->|No| K[リモートリンク作成]
    J --> K
    K --> L{MRマージ?}
    L -->|No| C
    L -->|Yes| M{遷移有効?}
    M -->|No| C
    M -->|Yes| N[ステータス遷移]
    N --> O[解決コメント投稿]
    O --> C
    H --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-01 | 認証タイプ制限 | Jira CloudはBasic認証のみ対応 | Jira Cloud使用時 |
| BR-96-02 | イシューキーパターン | デフォルトは{PROJECT-KEY}-{NUMBER}形式 | イシュー検索時 |
| BR-96-03 | 重複コメント防止 | 同一メッセージのコメントは重複作成しない | コメント投稿時 |
| BR-96-04 | 遷移順序 | jira_issue_transition_idの順序で遷移を試行 | 手動遷移ID指定時 |
| BR-96-05 | 自動遷移 | statusCategoryが'done'の遷移を自動選択 | 自動遷移有効時 |
| BR-96-06 | updateイベント除外 | コミット/MRの更新イベントは通知対象外 | イベント判定時 |

### API エンドポイント

| エンドポイント | 用途 |
|--------------|------|
| /rest/api/2/issue/{issueKey} | イシュー取得 |
| /rest/api/2/serverInfo | サーバー情報取得 |
| /rest/api/2/myself | 認証ユーザー情報取得 |
| /rest/api/2/issue/{issueKey}/transitions | イシュー遷移 |
| /rest/api/2/issue/{issueKey}/comment | コメント投稿 |
| /rest/api/2/issue/{issueKey}/remotelink | リモートリンク作成 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | integrations | INSERT/UPDATE | Jira連携設定の保存 |
| データフィールド | jira_tracker_data | INSERT/UPDATE | 認証情報等の保存 |

### テーブル別操作詳細

#### integrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | type, active, project_id/group_id | フォーム入力値 | type='Integrations::Jira' |

#### jira_tracker_data

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | url, api_url, username, encrypted_password, jira_auth_type, project_keys, deployment_type | フォーム入力値 | 外部キー: integration_id |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 401 | 認証エラー | 認証情報が不正 | 認証情報を確認 |
| 403 | 権限エラー | Jiraプロジェクトへのアクセス権なし | 権限を確認 |
| 404 | 未検出 | イシューが存在しない | イシューキーを確認 |
| - | 遷移エラー | 指定した遷移が許可されていない | Jiraワークフロー設定を確認 |

## セキュリティ考慮事項

- **パスワード暗号化**：encrypted_passwordカラムに暗号化保存
- **PATサポート**：Jira Data Center/Server向けにPersonal Access Token対応
- **Basic認証**：Jira CloudはAPIトークンを使用
- **SSL通信**：Jira APIへの通信はHTTPS推奨

## 備考

- Jira Cloud(.atlassian.net)とJira Data Center/Serverで認証方式が異なる
- deployment_typeはAPIレスポンスまたはURLから自動判定
- Premium機能としてGitLab内でのJiraイシュー表示が可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: Jiraインテグレーションモデル

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | jira.rb | `app/models/integrations/jira.rb` | Jira連携のメインクラス |

**主要処理フロー**:
- **24-31行目**: API_ENDPOINTS定義
- **44-60行目**: バリデーション
- **190-192行目**: supported_events（commit, merge_request）
- **356-367行目**: find_issue - Jiraイシュー取得
- **369-387行目**: close_issue - イシュークローズ処理
- **389-425行目**: create_cross_reference_note - クロスリファレンス作成
- **510-546行目**: transition_issue - ステータス遷移処理

### プログラム呼び出し階層図

```
Project#execute_integrations
    |
    +-- Integrations::Jira#execute (no-op)

Project#external_issue_tracker
    |
    +-- Integrations::Jira#find_issue
    +-- Integrations::Jira#close_issue
    +-- Integrations::Jira#create_cross_reference_note
            |
            +-- JIRA::Client (jira-ruby gem)
                    |
                    +-- Gitlab::Jira::HttpClient
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| jira.rb | `app/models/integrations/jira.rb` | ソース | Jira連携インテグレーション |
| jira_tracker_data.rb | `app/models/integrations/jira_tracker_data.rb` | ソース | Jira設定データ |
| jira_cloud_app.rb | `app/models/integrations/jira_cloud_app.rb` | ソース | Jira Cloud App連携 |
| issue_tracker.rb | `app/models/concerns/integrations/base/issue_tracker.rb` | ソース | イシュートラッカー基底 |
