---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-プロジェクト作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（3秒以内）**：コードからの明確な根拠なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects_controller.rb` - ProjectsController#createアクション（114-125行目）
- E-02: `app/services/projects/create_service.rb` - Projects::CreateServiceクラス全体
- E-03: `app/services/projects/create_service.rb` - executeメソッド（27-104行目）
- E-04: `app/services/projects/create_service.rb` - save_project_and_import_dataメソッド（250-275行目）
- E-05: `app/services/projects/create_service.rb` - after_create_actionsメソッド（126-157行目）
- E-06: `app/services/projects/create_service.rb` - validate_create_permissions（108-112行目）
- E-07: `app/services/projects/create_service.rb` - setup_authorizations（166-203行目）
- E-08: `app/models/project.rb` - Projectモデル定義（1-200行目+）
- E-09: `app/controllers/projects_controller.rb` - project_params_attributes（527-572行目）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.1の定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.25との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createアクションがProjects::CreateServiceを呼び出す | E-01 | ○ |
| C-02 | 名前、パス、可視性レベルなどの入力パラメータがある | E-09 | ○ |
| C-03 | テンプレート使用時はCreateFromTemplateServiceへ委譲 | E-03 (35-37行目) | ○ |
| C-04 | プロジェクトインスタンスはProject.newで生成 | E-03 (39-44行目) | ○ |
| C-05 | 可視性レベルは名前空間以下に制限される | E-03 (52行目) | ○ |
| C-06 | 個人プロジェクト数の制限チェックがある | E-03 (69行目) | ○ |
| C-07 | トランザクション内でプロジェクトが保存される | E-04 | ○ |
| C-08 | リポジトリはcreate_repositoryで作成される | E-04 (269-271行目) | ○ |
| C-09 | インテグレーションがデフォルトからコピーされる | E-04 (262行目) | ○ |
| C-10 | 作成後にシステムフックが実行される | E-05 (144行目) | ○ |
| C-11 | オーナー権限がsetup_authorizationsで設定される | E-07 | ○ |
| C-12 | READMEの初期作成オプションがある | E-02 (16行目), E-05 (152行目) | ○ |
| C-13 | SASTの初期設定オプションがある | E-02 (14行目), E-05 (153行目) | ○ |
| C-14 | プロジェクト作成イベントが発行される | E-05 (156行目), E-02 (371-379行目) | ○ |
| C-15 | Wikiが有効時に作成される | E-05 (133-135行目) | ○ |
| C-16 | 名前空間への作成権限チェックがある | E-06 | ○ |
| C-17 | インポート権限チェックがある | E-02 (114-124行目) | ○ |
| C-18 | runners_tokenが自動生成される | E-08 (137-140行目) | ○ |
| C-19 | repository_storageにデフォルト値がある | E-08 (130行目) | ○ |
| C-20 | プロジェクトフィーチャーが作成後に設定される | E-08 (156行目) | ○ |
| C-21 | 画面No.25がプロジェクト新規作成画面 | E-11 | ○ |
| C-22 | 機能No.1がプロジェクト作成機能 | E-10 | ○ |
| C-23 | pathが未指定時はnameから自動生成 | E-02 (291-308行目) | ○ |
| C-24 | PostCreationWorkerで非同期処理が実行される | E-05 (150行目) | ○ |
| C-25 | プロジェクト作成処理は3秒以内に完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（3秒以内）について、コード上での明確なタイムアウト設定や性能目標の記載が見当たらない
  - 候補：運用ドキュメント / 性能テスト仕様書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる
- 1: 中リスク - パフォーマンス要件の根拠確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（3秒以内）の根拠を運用ドキュメントから確認
- [ ] 入力パラメータのバリデーションルールがコードと一致しているか確認
- [ ] エラーコード一覧がシステム全体のエラーコード体系と整合しているか確認
