---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-グループ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - updateアクション（156-169行目）
- E-02: `app/controllers/groups_controller.rb` - authorize_admin_group!（23行目）
- E-03: `app/services/groups/update_service.rb` - executeメソッド（11-44行目）
- E-04: `app/services/groups/update_service.rb` - reject_parent_id!（105-107行目）
- E-05: `app/services/groups/update_service.rb` - remove_unallowed_params（110-128行目）
- E-06: `app/services/groups/update_service.rb` - renaming_group_with_container_registry_images?（72-74行目）
- E-07: `app/services/groups/update_service.rb` - valid_path_change?（48-65行目）
- E-08: `app/services/groups/update_service.rb` - valid_share_with_group_lock_change?（166-172行目）
- E-09: `app/services/groups/update_service.rb` - update_shared_runners（180-189行目）
- E-10: `app/services/groups/update_service.rb` - handle_changes（130-133行目）
- E-11: `app/services/groups/update_service.rb` - handle_crm_settings_update（143-160行目）
- E-12: `app/services/groups/update_service.rb` - after_update（86-93行目）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.10の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | updateアクションがUpdateServiceを呼び出す | E-01 (157行目) | ○ |
| C-02 | admin_group権限チェックがある | E-02 | ○ |
| C-03 | executeでreject_parent_id!が呼ばれる | E-03 (12行目) | ○ |
| C-04 | executeでremove_unallowed_paramsが呼ばれる | E-03 (13行目) | ○ |
| C-05 | Container Registry画像チェックがある | E-03 (17-20行目), E-06 | ○ |
| C-06 | 可視性レベル検証がある | E-03 (22行目) | ○ |
| C-07 | share_with_group_lock検証がある | E-03 (23行目) | ○ |
| C-08 | パス変更検証がある | E-03 (24行目), E-07 | ○ |
| C-09 | 共有ランナー設定更新がある | E-03 (25行目), E-09 | ○ |
| C-10 | handle_changesで設定更新 | E-03 (27行目), E-10 | ○ |
| C-11 | group.assign_attributesで属性更新 | E-03 (29行目) | ○ |
| C-12 | group.saveで保存 | E-03 (34行目) | ○ |
| C-13 | 保存成功時にafter_updateが呼ばれる | E-03 (36行目) | ○ |
| C-14 | parent_idが削除される | E-04 | ○ |
| C-15 | emails_enabledは権限チェックで削除 | E-05 (115行目) | ○ |
| C-16 | max_artifacts_sizeは権限チェックで削除 | E-05 (116行目) | ○ |
| C-17 | NPMパッケージでパス変更制限 | E-07 (56-64行目) | ○ |
| C-18 | share_with_group_lock変更時の親チェック | E-08 | ○ |
| C-19 | CRM設定更新がある | E-10, E-11 | ○ |
| C-20 | 可視性private時にTodo削除がスケジュールされる | E-12 (87-90行目) | ○ |
| C-21 | 二要素認証設定変更時の処理がある | E-12 (92行目), `app/services/groups/update_service.rb` (95-103行目) | ○ |
| C-22 | 機能No.10がグループ編集機能 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] CRM設定変更時の連絡先制限について詳細が文書化されているか確認
- [ ] 共有ランナー設定の階層継承ルールについて詳細が必要か検討
- [ ] 二要素認証設定変更の影響範囲について文書化されているか確認
