---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：100-REST API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **レート制限の詳細実装**：RateLimiterの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/api/api.rb`（APIメインエントリーポイント）
- E-02: `lib/api/api_guard.rb`（認証ガード）
- E-03: `lib/api/helpers.rb`（共通ヘルパー）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Grapeフレームワーク使用 | E-01 (4行目 class API < ::API::Base) | ○ |
| C-02 | APIGuardでOAuth2認証 | E-02 (14-19行目 Rack::OAuth2) | ○ |
| C-03 | prefix :api | E-01 (55行目) | ○ |
| C-04 | V3は410エラー | E-01 (57-61行目) | ○ |
| C-05 | V4バージョン | E-01 (63行目) | ○ |
| C-06 | X-Frame-Options設定 | E-01 (66行目) | ○ |
| C-07 | X-Content-Type-Options設定 | E-01 (67行目) | ○ |
| C-08 | CSP設定 | E-01 (69-73行目) | ○ |
| C-09 | ApplicationContext設定 | E-01 (85-94行目) | ○ |
| C-10 | api_json.logへ出力 | E-01 (10行目 LOG_FILENAME) | ○ |
| C-11 | allow_access_with_scope api | E-01 (53行目) | ○ |
| C-12 | allow_access_with_scope read_api | E-01 (54行目) | ○ |
| C-13 | JSON形式のみ | E-01 (193-195行目 format :json) | ○ |
| C-14 | find_current_user!で認証 | E-02 (57-71行目) | ○ |
| C-15 | find_user_from_sources認証元 | E-02 (73-85行目) | ○ |
| C-16 | deploy_token対応 | E-02 (79行目) | ○ |
| C-17 | bearer_token対応 | E-02 (80行目) | ○ |
| C-18 | job_token対応 | E-02 (81行目) | ○ |
| C-19 | api_access_allowed?判定 | E-02 (117-119行目) | ○ |
| C-20 | 2FA検証 | E-02 (163-171行目 two_factor_required_but_not_setup?) | ○ |
| C-21 | エラークラス定義 | E-02 (178-186行目) | ○ |
| C-22 | InsufficientScopeError対応 | E-02 (218-224行目) | ○ |
| C-23 | SUDO_HEADER定義 | E-03 (14行目) | ○ |
| C-24 | current_user取得 | E-03 (81-100行目) | ○ |
| C-25 | rescue_from AccessDeniedError | E-01 (130-132行目) | ○ |
| C-26 | rescue_from RecordNotFound | E-01 (134-136行目) | ○ |
| C-27 | rescue_from RateLimitedError | E-01 (188-191行目) | ○ |
| C-28 | レート制限の詳細実装 | **RateLimiter実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Helpers::RateLimiterの実装詳細
  - 候補：`lib/api/helpers/rate_limiter.rb`
- Grape::Entityシリアライザの一覧
  - 候補：`lib/api/entities/*.rb`
- ページネーションの詳細実装
  - 候補：`lib/api/helpers/pagination.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API基本構造、認証フロー
- 1: 中リスク - レート制限の詳細（DoS対策）
- 0: 低リスク - エラーハンドリング、スコープ検証

## 6) レビュアーチェックリスト（最小）
- [ ] Helpers::RateLimiterの実装を確認
- [ ] Grape::Entityシリアライザの一貫性を確認
- [ ] ページネーションのデフォルト値と最大値を確認
- [ ] 内部API（/api/v4/internal/*）の認証方式を確認
- [ ] IDE拡張機能の使用状況追跡の範囲を確認
