---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：102-グローバル検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Elasticsearch/Zoekt連携の詳細**：EE機能のため別途確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/search_controller.rb`
- E-02: `app/services/search/global_service.rb`
- E-03: `app/services/search/project_service.rb`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトスコープは'projects' | E-02 (8行目 DEFAULT_SCOPE) | ○ |
| C-02 | 検索文字数制限は256文字 | E-01 (191行目 SEARCH_CHAR_LIMIT参照) | ○ |
| C-03 | 検索語数制限は64語 | E-01 (196行目 SEARCH_TERM_LIMIT参照) | ○ |
| C-04 | 結果カウントは1分キャッシュ | E-01 (93行目 expires_in 1.minute) | ○ |
| C-05 | レート制限チェックが実装されている | E-01 (39行目 check_search_rate_limit!) | ○ |
| C-06 | 単一コミット結果でリダイレクト | E-01 (216-238行目 check_single_commit_result?) | ○ |
| C-07 | Gitaly参照キャッシュ有効 | E-01 (29行目 allow_gitaly_ref_name_caching) | ○ |
| C-08 | feature_category は global_search | E-01 (45行目) | ○ |
| C-09 | urgency は low | E-01 (46行目) | ○ |
| C-10 | 匿名検索制御設定がある | E-01 (143行目 anonymous_searches_allowed?) | ○ |
| C-11 | オートコンプリート機能がある | E-01 (113-129行目 autocomplete) | ○ |
| C-12 | ProjectsFinder でプロジェクト取得 | E-02 (29行目) | ○ |
| C-13 | topics, project_topics, route をプリロード | E-02 (29行目) | ○ |
| C-14 | Apdexメトリクス記録 | E-01 (161-166行目 record_apdex) | ○ |
| C-15 | 機能一覧でNo.102はグローバル検索 | E-04 | ○ |
| C-16 | 画面No.284は検索結果 | E-05 | ○ |
| C-17 | with_fast_read_statement_timeout使用 | E-01 (82行目) | ○ |
| C-18 | タイムアウト時のレスキュー処理 | E-01 (41行目、288-303行目) | ○ |
| C-19 | クロスプロジェクトアクセス権限チェック | E-01 (35-38行目 requires_cross_project_access) | ○ |
| C-20 | Elasticsearch/Zoekt連携詳細 | **根拠不足（EE機能）** | △ |

## 4) 不足情報（Unknown / Missing）
- Elasticsearch/Zoekt連携の詳細実装
  - 候補：`ee/app/services/search/` / `ee/lib/gitlab/elastic/` / Zoekt関連実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CE機能の記述は全てコードから確認済み
- 1: 中リスク - EE固有の検索エンジン連携は別途確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] 検索文字数・語数制限が Gitlab::Search::Params の定数と一致するか確認
- [ ] レート制限の具体的な値を確認
- [ ] EE環境でのElasticsearch/Zoekt有効化条件を確認
