---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：103-プロジェクト内検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Gitaly連携詳細**：コード検索時のGitaly呼び出し詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/search_controller.rb`
- E-02: `app/services/search/project_service.rb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Search::ProjectServiceがプロジェクト内検索を実行 | E-02 | ○ |
| C-02 | Gitlab::ProjectSearchResultsが結果を管理 | E-02 (17行目) | ○ |
| C-03 | repository_ref でブランチ/タグ指定可能 | E-02 (19行目) | ○ |
| C-04 | allowed_scopesで許可スコープを取得 | E-02 (27-33行目) | ○ |
| C-05 | scopeメソッドで有効スコープを決定 | E-02 (35-49行目) | ○ |
| C-06 | Search::Navigationでタブ有効性チェック | E-02 (36行目) | ○ |
| C-07 | カスタムデフォルトスコープ設定対応 | E-02 (40-43行目) | ○ |
| C-08 | プロジェクトがsearched_containerとして使用 | E-02 (54-56行目) | ○ |
| C-09 | 機能一覧でNo.103はプロジェクト内検索 | E-03 | ○ |
| C-10 | 画面No.46はファイル検索 | E-04 | ○ |
| C-11 | filtersでフィルタリング条件適用 | E-02 (23行目) | ○ |
| C-12 | order_by, sortでソート指定 | E-02 (21-22行目) | ○ |
| C-13 | search_typeパラメータ対応 | E-02 (31行目) | ○ |
| C-14 | contextは:project | E-02 (29行目) | ○ |
| C-15 | Gitaly連携のコード検索詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitalyを使用したコード検索の詳細実装
  - 候補：`lib/gitlab/project_search_results.rb` / `lib/gitlab/git/` / Gitaly関連実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サービス層の記述は全てコードから確認済み
- 1: 中リスク - Gitaly連携の詳細は追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクト設定によるスコープ無効化の動作を確認
- [ ] コード検索時のread_code権限チェックを確認
- [ ] 大規模リポジトリでのパフォーマンスを確認
