---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 8
  claims_without_evidence: 4
confidence_derived: 0.67
---

# 根拠レポート：104-高度な検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.67**
  - 根拠あり：8 / 12、根拠なし：4
- 優先レビュー（高）
  1. **Elasticsearch連携詳細**：EE機能のため別途ソース確認必要
  2. **Zoekt連携詳細**：EE機能のため別途ソース確認必要
  3. **インデックス更新ロジック**：Sidekiqジョブの詳細確認必要
  4. **ファセット集計機能**：EE実装の詳細確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/search_controller.rb`
- E-02: `app/services/search/global_service.rb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | search_typeパラメータで検索タイプ判定 | E-01 (57行目、313-315行目) | ○ |
| C-02 | 機能一覧でNo.104は高度な検索 | E-03 | ○ |
| C-03 | 画面No.284は検索結果 | E-04 | ○ |
| C-04 | prepend_mod_withでEE拡張 | E-01 (336行目)、E-02 (61行目) | ○ |
| C-05 | 基本検索はGitlab::SearchResults使用 | E-02 (17-24行目) | ○ |
| C-06 | スコープ判定ロジックが存在 | E-02 (40-43行目) | ○ |
| C-07 | フィルタ機能が存在 | E-02 (22行目 filters) | ○ |
| C-08 | search_type_errorsでバリデーション | E-01 (206-210行目) | ○ |
| C-09 | Elasticsearch連携詳細 | **根拠不足（EE機能）** | △ |
| C-10 | Zoekt連携詳細 | **根拠不足（EE機能）** | △ |
| C-11 | インデックス更新ロジック | **根拠不足（EE機能）** | △ |
| C-12 | ファセット集計機能 | **根拠不足（EE機能）** | △ |

## 4) 不足情報（Unknown / Missing）
- Elasticsearch/OpenSearch連携の詳細実装
  - 候補：`ee/app/services/search/` / `ee/lib/gitlab/elastic/`
- Zoektコード検索エンジン連携
  - 候補：`ee/lib/gitlab/search/zoekt/`
- インデックス更新Sidekiqジョブ
  - 候補：`ee/app/workers/elastic_*`
- ファセット集計機能の実装
  - 候補：`ee/lib/gitlab/elastic/`

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 主要機能がEE専用のため、CE版コードベースからは確認不可
- EE版ソースコードへのアクセスが必要

## 6) レビュアーチェックリスト（最小）
- [ ] EE版ソースコードでElasticsearch連携を確認
- [ ] Zoekt有効化条件を確認
- [ ] インデックス更新のタイミングを確認
- [ ] ファセット集計のパフォーマンスを確認
