---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：105-GitHubインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **バックグラウンドインポート詳細**：Sidekiqジョブの詳細実装

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/import/github_controller.rb`
- E-02: `app/services/import/github_service.rb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth認証とPAT認証の両方をサポート | E-01 (26-48行目) | ○ |
| C-02 | state検証でCSRF防止 | E-01 (36-38行目) | ○ |
| C-03 | セッションにトークン保存 | E-01 (40行目、46行目) | ○ |
| C-04 | ページサイズは25件 | E-01 (24行目 PAGE_LENGTH) | ○ |
| C-05 | レート制限エラーハンドリング | E-01 (18行目、245-249行目) | ○ |
| C-06 | Forbidden/Unauthorizedエラーハンドリング | E-01 (17行目、19行目、236-269行目) | ○ |
| C-07 | Import::GithubServiceでインポート実行 | E-01 (73行目) | ○ |
| C-08 | realtime_changesでポーリング | E-01 (82-86行目、3秒間隔) | ○ |
| C-09 | owner_access権限チェック | E-01 (165-167行目) | ○ |
| C-10 | import_projects権限チェック | E-02 (133-135行目) | ○ |
| C-11 | レート制限チェック | E-02 (39-41行目) | ○ |
| C-12 | repoスコープ検証 | E-02 (91-96行目) | ○ |
| C-13 | read:orgスコープ検証 | E-02 (98-104行目) | ○ |
| C-14 | Fine-grained tokens非サポート | E-02 (108-113行目、115-121行目) | ○ |
| C-15 | ブロックURL検証 | E-02 (78-86行目) | ○ |
| C-16 | タイムアウト戦略設定 | E-02 (176行目) | ○ |
| C-17 | 機能一覧でNo.105はGitHubインポート | E-03 | ○ |
| C-18 | 画面No.285-287がGitHubインポート関連 | E-04 | ○ |
| C-19 | GitHubエラーログ出力 | E-02 (144-160行目) | ○ |
| C-20 | LegacyGithubImport::ProjectCreator使用 | E-02 (44-51行目) | ○ |
| C-21 | Giteaインポートも同じコントローラ | E-01 (148-150行目 provider_name) | ○ |
| C-22 | バックグラウンドインポート詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- バックグラウンドインポートの詳細実装
  - 候補：`lib/gitlab/github_import/` / `app/workers/` / Sidekiqジョブ実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラとサービスの記述は全てコードから確認済み
- 1: 中リスク - バックグラウンドジョブの詳細は追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth設定（app_id, app_secret）の設定方法を確認
- [ ] GitHub Enterpriseのカスタムホスト設定を確認
- [ ] 大規模リポジトリのインポート時間を確認
- [ ] インポート失敗時のリトライ動作を確認
