---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：107-Bitbucketインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **バックグラウンドインポート詳細**：Sidekiqジョブ実装の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/import/bitbucket_controller.rb`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth2認証実装 | E-01 (16-35行目 callback) | ○ |
| C-02 | state検証でCSRF防止 | E-01 (20行目) | ○ |
| C-03 | トークンをセッションに保存 | E-01 (28-31行目) | ○ |
| C-04 | ページサイズは25件 | E-01 (14行目 PAGE_LENGTH) | ○ |
| C-05 | 有効/無効リポジトリ分類 | E-01 (103-111行目) | ○ |
| C-06 | provider_nameはbitbucket | E-01 (117-119行目) | ○ |
| C-07 | ProjectCreatorでプロジェクト作成 | E-01 (82-88行目) | ○ |
| C-08 | import_projects権限チェック | E-01 (77行目) | ○ |
| C-09 | トークン自動更新 | E-01 (79-80行目) | ○ |
| C-10 | 名前空間解決ロジック | E-01 (64-67行目) | ○ |
| C-11 | 機能一覧でNo.107はBitbucketインポート | E-02 | ○ |
| C-12 | 画面No.291-293がBitbucketインポート関連 | E-03 | ○ |
| C-13 | ユーザーロール追跡 | E-01 (128-141行目) | ○ |
| C-14 | OAuth認証リダイレクト | E-01 (175-182行目) | ○ |
| C-15 | フィルタパラメータ対応 | E-01 (155-161行目) | ○ |
| C-16 | バックグラウンドインポート詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- バックグラウンドインポートの詳細実装
  - 候補：`lib/gitlab/bitbucket_import/` / `app/workers/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラの記述は確認済み
- 1: 中リスク - バックグラウンドジョブの詳細は追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth設定（app_id, app_secret）の設定方法を確認
- [ ] Bitbucket Server連携との違いを確認
- [ ] Mercurialリポジトリの除外動作を確認
