---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：108-プロジェクトエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パラレルエクスポート詳細**：EE機能の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/projects/import_export/export_service.rb`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | admin_project権限チェック | E-01 (16行目) | ○ |
| C-02 | template_source?例外 | E-01 (16行目) | ○ |
| C-03 | 9種類のExporter | E-01 (26-30行目) | ○ |
| C-04 | save_all!でエクスポート実行 | E-01 (56-71行目) | ○ |
| C-05 | save_exportersで順次実行 | E-01 (73-79行目) | ○ |
| C-06 | Saver.saveでアーカイブ作成 | E-01 (81-83行目) | ○ |
| C-07 | 内部イベント追跡 | E-01 (59-64行目) | ○ |
| C-08 | 失敗通知 | E-01 (151-163行目) | ○ |
| C-09 | クリーンアップ処理 | E-01 (134-136行目) | ○ |
| C-10 | ログ出力 | E-01 (144-149行目) | ○ |
| C-11 | アフターエクスポート戦略 | E-01 (48-53行目) | ○ |
| C-12 | TreeSaverでツリー保存 | E-01 (93-100行目) | ○ |
| C-13 | ImportExport::Error.permission_error使用 | E-01 (17行目) | ○ |
| C-14 | 機能一覧でNo.108はプロジェクトエクスポート | E-02 | ○ |
| C-15 | shared.errors収集 | E-01 (141行目) | ○ |
| C-16 | パラレルエクスポート詳細 | **根拠不足（EE機能）** | △ |

## 4) 不足情報（Unknown / Missing）
- パラレルエクスポートの詳細実装
  - 候補：`ee/app/services/projects/import_export/parallel_export_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CE機能の記述は確認済み
- 1: 中リスク - パラレルエクスポート（EE）は別途確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各Exporterの実行順序の依存関係を確認
- [ ] 大規模プロジェクトのエクスポート時間を確認
- [ ] エクスポートファイルの保存期間を確認
- [ ] 監査ログへの記録を確認
