---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-グループエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/groups/import_export/export_service.rb`
- E-02: `lib/gitlab/import_export/group/tree_saver.rb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | admin_group権限チェック | E-01 (39行目) | ○ |
| C-02 | 既存エクスポート削除 | E-01 (46-51行目) | ○ |
| C-03 | VersionSaverとTreeExporter使用 | E-01 (75-77行目) | ○ |
| C-04 | save_exportersで順次実行 | E-01 (65-73行目) | ○ |
| C-05 | file_saverでアーカイブ作成 | E-01 (92-94行目) | ○ |
| C-06 | 監査ログ記録 | E-01 (114-126行目) | ○ |
| C-07 | サイレント管理者エクスポート | E-01 (115行目) | ○ |
| C-08 | 成功通知 | E-01 (128-132行目) | ○ |
| C-09 | 失敗通知 | E-01 (134-143行目) | ○ |
| C-10 | クリーンアップ処理 | E-01 (96-98行目) | ○ |
| C-11 | 非同期エクスポート(GroupExportWorker) | E-01 (15-21行目) | ○ |
| C-12 | サブグループ階層取得 | E-02 (37-42行目) | ○ |
| C-13 | NdjsonWriter形式 | E-02 (67-69行目) | ○ |
| C-14 | depth順でグループ取得 | E-02 (41行目 order_by(:depth)) | ○ |
| C-15 | 機能一覧でNo.109はグループエクスポート | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] エクスポートファイルの保存期間を確認
- [ ] 大規模グループ（多数のサブグループ）の処理時間を確認
- [ ] EE機能での追加エクスポート内容を確認
- [ ] 監査ログのsilent_admin_exports_enabled動作を確認
