---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-グループ削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **猶予期間の具体的な日数**：設定ファイルまたはシステム設定による可能性
  2. **通知メール送信の詳細仕様**：NotificationServiceの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/groups_controller.rb` - GroupsController
- E-02: `app/services/groups/mark_for_deletion_service.rb` - MarkForDeletionService
- E-03: `app/services/groups/destroy_service.rb` - DestroyService
- E-04: `app/models/group.rb` - Groupモデル
- E-05: `app/services/groups/restore_service.rb` - RestoreService（コントローラーから参照確認）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループオーナーまたは管理者権限が削除に必要 | E-01 (26行目: authorize_remove_group!) | ○ |
| C-02 | 削除スケジュール設定（ソフトデリート）方式 | E-02 (22-43行目: execute_deletion) | ○ |
| C-03 | 猶予期間経過後の完全削除 | E-01, E-03 | ○ |
| C-04 | 配下プロジェクトの再帰的削除 | E-03 (19-24行目: group.projects.find_each) | ○ |
| C-05 | サブグループの再帰的削除 | E-03 (29-32行目: group.children.each) | ○ |
| C-06 | Mattermostチーム削除 | E-03 (34行目: chat_team&.remove_mattermost_team) | ○ |
| C-07 | GroupDeletedEventの発行 | E-03 (137-145行目: publish_event) | ○ |
| C-08 | 即時削除は管理者のみ可能 | E-01 (185行目: allow_immediate_namespaces_deletion_for_user) | ○ |
| C-09 | permanently_removeパラメータの存在 | E-01 (182行目: params.permit(:permanently_remove)) | ○ |
| C-10 | グループ名・パスに削除サフィックスを付与 | E-02 (62-67行目: suffixed_identifier) | ○ |
| C-11 | deletion_scheduleレコードの作成 | E-02 (69-77行目: save_deletion_schedule!) | ○ |
| C-12 | コンテナレジストリ制限 | E-02 (58-60行目: rename_group_for_deletion?) | ○ |
| C-13 | ブロックユーザーの削除防止 | E-03 (72行目: current_user.blocked?) | ○ |
| C-14 | 削除失敗時の再スケジュール | E-03 (82-86行目: reschedule_deletion) | ○ |
| C-15 | 関連画面: グループ編集 | E-07 (画面No 143) | ○ |
| C-16 | 関連画面: 管理者グループ編集 | E-07 (画面No 235) | ○ |
| C-17 | 機能カテゴリ: グループ管理 | E-06 (No.11) | ○ |
| C-18 | 非同期削除はGroupDestroyWorkerで実行 | E-03 (10行目: GroupDestroyWorker.perform_async) | ○ |
| C-19 | プロジェクト権限リフレッシュ | E-03 (43-47行目: UserProjectAccessChangedService) | ○ |
| C-20 | ボットユーザーの削除 | E-03 (117-126行目: destroy_associated_users) | ○ |
| C-21 | 削除後の復元機能 | E-01 (221-231行目: restore) | ○ |
| C-22 | トランザクション管理 | E-02 (30行目: resource.transaction), E-03 | ○ |
| C-23 | 監査ログの記録 | E-03 (11行目: Gitlab::AppLogger.info) | ○ |
| C-24 | 猶予期間の具体的な日数 | **根拠なし** | △ |
| C-25 | 通知メール送信のタイミングと内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 猶予期間の具体的な日数設定
  - 候補：`ApplicationSetting` / `Gitlab::CurrentSettings` / 環境変数
- 通知メール送信の詳細
  - 候補：`NotificationService` / `Mailer` / メールテンプレート

## 5) リスクフラグ（レビュー観点）
- 0: 削除権限チェックロジック - 十分なカバレッジあり
- 0: カスケード削除のデータ整合性 - コード上で確認済み
- 1: 猶予期間設定の確認 - 設定値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 削除権限（authorize_remove_group!）の実装が適切か確認
- [ ] 猶予期間の日数がApplicationSettingで設定されているか確認
- [ ] 通知メール送信のNotificationService実装を確認
- [ ] GroupDeletedEventのサブスクライバーを確認
- [ ] カスケード削除のトランザクション範囲が適切か確認
