---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：110-バルクインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **BulkImportWorkerの詳細実装**：非同期処理の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/import/bulk_imports_controller.rb`
- E-02: `app/services/bulk_imports/create_service.rb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bulk_import_enabled設定チェック | E-01 (160-163行目) | ○ |
| C-02 | URLブロック確認 | E-01 (173-187行目) | ○ |
| C-03 | ポーリング間隔3秒 | E-01 (14行目 POLLING_INTERVAL = 3_000) | ○ |
| C-04 | レート制限 | E-01 (234-236行目) | ○ |
| C-05 | group_entityのみ許可 | E-01 (144-146行目) | ○ |
| C-06 | min_access_level=OWNER | E-01 (119行目) | ○ |
| C-07 | top_level_only=true | E-01 (118行目) | ○ |
| C-08 | セッションにトークン保存 | E-01 (18-20行目, 219-224行目) | ○ |
| C-09 | トランザクションでBulkImport作成 | E-02 (83-113行目) | ○ |
| C-10 | source_type='gitlab' | E-02 (86行目) | ○ |
| C-11 | BulkImportWorker.perform_async | E-02 (60行目) | ○ |
| C-12 | validate_destination_namespace | E-02 (162-174行目) | ○ |
| C-13 | validate_destination_full_path | E-02 (182-198行目) | ○ |
| C-14 | GraphQL APIでソースパス検証 | E-02 (116-127行目) | ○ |
| C-15 | ユーザーマッピング機能 | E-02 (57-58行目) | ○ |
| C-16 | migrate_projects/membershipsパラメータ | E-02 (108-109行目) | ○ |
| C-17 | 機能一覧でNo.110はバルクインポート | E-03 | ○ |
| C-18 | BulkImportWorkerの詳細実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- BulkImportWorkerの詳細実装
  - 候補：`app/workers/bulk_import_worker.rb`、`lib/bulk_imports/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ・サービスの記述は確認済み
- 1: 中リスク - バックグラウンド処理の詳細は追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 大規模グループのインポート時間を確認
- [ ] サブグループ・プロジェクトの再帰的インポート動作を確認
- [ ] ユーザーマッピングの詳細仕様を確認
- [ ] インポート失敗時のリトライ動作を確認
- [ ] レート制限の閾値を確認
