---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：111-ユーザー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：ベンチマーク結果等の根拠不足
  2. **メール通知の詳細仕様**：Mailerクラスの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/controllers/admin/users_controller.rb` - ユーザー管理コントローラー
- E-02: `app/models/user.rb` - Userモデル
- E-03: `app/services/users/create_service.rb` - ユーザー作成サービス
- E-04: `app/services/users/update_service.rb` - ユーザー更新サービス
- E-05: `app/services/users/destroy_service.rb` - ユーザー削除サービス
- E-06: `app/services/users/block_service.rb` - ユーザーブロックサービス
- E-07: `app/services/users/approve_service.rb` - ユーザー承認サービス
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | ユーザー一覧でフィルタリング・検索・ソートが可能 | E-01（16-32行目: index アクション） | ○ |
| C-03 | 1000件以上でカウントなしページネーション使用 | E-01（14行目: PAGINATION_WITH_COUNT_LIMIT、324-328行目: paginate_without_count?） | ○ |
| C-04 | ユーザー作成時にパスワードリセットメールを送信 | E-03（24-26行目: after_create_hook） | ○ |
| C-05 | Users::CreateServiceでユーザー作成を処理 | E-01（218行目）、E-03 | ○ |
| C-06 | Users::UpdateServiceでユーザー更新を処理 | E-01（259行目）、E-04 | ○ |
| C-07 | ユーザー削除は非同期で実行される | E-01（278行目: delete_async） | ○ |
| C-08 | ゴーストユーザーへの移行が行われる | E-05（86-94行目: create_ghost_user） | ○ |
| C-09 | 内部ユーザーはブロックできない | E-06（10行目: user.internal?チェック） | ○ |
| C-10 | LDAPブロックユーザーは手動アンブロック不可 | E-01（133-134行目: user.ldap_blocked?） | ○ |
| C-11 | 単独オーナーグループ確認が削除前に行われる | E-01（342-351行目: ensure_destroy_prerequisites_met） | ○ |
| C-12 | 偽装機能は設定で有効/無効を制御 | E-01（421-422行目: check_impersonation_availability） | ○ |
| C-13 | 偽装操作はログに記録される | E-01（425-428行目: log_impersonation_event） | ○ |
| C-14 | パスワード変更時に有効期限が即座に切れる | E-01（248行目: password_expires_at = Time.current） | ○ |
| C-15 | ブロック時にカスタム属性が記録される | E-06（25-30行目: UserCustomAttribute.upsert_custom_attributes） | ○ |
| C-16 | 2要素認証無効化はTwoFactor::DestroyServiceで実行 | E-01（204行目） | ○ |
| C-17 | ユーザー削除時にメンバーシップが先に削除される | E-05（64行目: user.members.each_batch） | ○ |
| C-18 | 単独オーナーグループは削除処理で破棄される | E-05（66-68行目: Groups::DestroyService） | ○ |
| C-19 | 個人プロジェクトは削除処理で破棄される | E-05（70-73行目: Projects::DestroyService） | ○ |
| C-20 | 関連画面No.224-231が存在する | E-09（224-231行目） | ○ |
| C-21 | ユーザー名は2〜255文字 | E-02（60-61行目: MAX_USERNAME_LENGTH, MIN_USERNAME_LENGTH） | ○ |
| C-22 | 名前は最大127文字 | E-02（62行目: MAX_NAME_LENGTH = 127） | ○ |
| C-23 | 組織所属は1つに制限されている | E-04（12行目: ORGANIZATION_USERS_LIMIT = 1） | ○ |
| C-24 | レスポンス時間要件（具体的数値） | **根拠なし** | △ |
| C-25 | メール通知の詳細テンプレート | **根拠なし**（Mailerクラス未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（レスポンス時間等）
  - 候補：ベンチマークテスト結果 / SLA定義ドキュメント / 運用監視設定
- メール通知テンプレートの詳細
  - 候補：`app/mailers/` / `app/views/mailers/` / DeviseのMailer設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の実装は明確に確認できる
- 1: 中リスク - パフォーマンス要件は実運用データでの確認が望ましい
- 0: 低リスク - セキュリティ関連の実装は適切に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] ユーザー一覧のページネーション閾値（1000件）が運用要件に適合しているか確認
- [ ] 偽装機能の監査ログが運用要件を満たしているか確認
- [ ] ユーザー削除の非同期処理が完了通知等を含むか確認
- [ ] メール通知の内容とタイミングが業務要件に適合しているか確認
