---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：112-グループ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Vue.jsコンポーネントの詳細実装**：フロントエンド実装の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/groups_controller.rb` - グループ管理コントローラー
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | グループ一覧で統計情報付きで取得 | E-01（74行目: Group.with_statistics） | ○ |
| C-03 | Groups::CreateServiceでグループ作成を処理 | E-01（37-38行目） | ○ |
| C-04 | Groups::UpdateServiceでグループ更新を処理 | E-01（52行目） | ○ |
| C-05 | グループ削除は非同期で実行される | E-01（64行目: async_execute） | ○ |
| C-06 | Runner登録無効化時に登録トークンをリセット | E-01（53-55行目） | ○ |
| C-07 | 管理者メモを追加可能 | E-01（29行目: build_admin_note、105-107行目: admin_note_attributes） | ○ |
| C-08 | メンバーはプレゼンター変換される | E-01（4行目: include MembersPresentation、19-22行目） | ○ |
| C-09 | アクセスリクエストが取得される | E-01（21-22行目: AccessRequestsFinder） | ○ |
| C-10 | プロジェクトは統計付きで取得される | E-01（23行目: @group.projects.with_statistics） | ○ |
| C-11 | 2要素認証の強制設定が可能 | E-01（99-100行目: require_two_factor_authentication, two_factor_grace_period） | ○ |
| C-12 | Git操作プロトコル制限が可能 | E-01（101行目: enabled_git_access_protocol） | ○ |
| C-13 | プロジェクト作成レベル設定が可能 | E-01（102行目: project_creation_level） | ○ |
| C-14 | サブグループ作成レベル設定が可能 | E-01（103行目: subgroup_creation_level） | ○ |
| C-15 | 組織IDの設定が可能 | E-01（104行目: organization_id） | ○ |
| C-16 | トースト通知で削除結果を表示 | E-01（66行目: flash[:toast]） | ○ |
| C-17 | 関連画面No.232-235が存在する | E-03（232-235行目） | ○ |
| C-18 | Vue.jsコンポーネントで一覧を描画 | **根拠なし**（フロントエンド実装未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsコンポーネントの実装詳細
  - 候補：`app/assets/javascripts/admin/groups/` / `ee/app/assets/javascripts/admin/groups/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バックエンドのコア機能は明確に確認できる
- 1: 中リスク - フロントエンド実装の詳細は別途確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] グループ削除の非同期処理が完了通知を含むか確認
- [ ] Runner登録トークンリセットの影響範囲を確認
- [ ] 2要素認証の猶予期間が業務要件に適合しているか確認
