---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-プロジェクト管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/projects_controller.rb` - プロジェクト管理コントローラー
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | プロジェクトはフルパスで検索される | E-01（75-79行目: find_by_full_path） | ○ |
| C-03 | グループメンバーはプレゼンター変換される | E-01（4行目: include MembersPresentation、15-17行目） | ○ |
| C-04 | プロジェクトメンバーはプレゼンター変換される | E-01（19-20行目） | ○ |
| C-05 | アクセスリクエストが取得される | E-01（21-22行目: AccessRequestsFinder） | ○ |
| C-06 | プロジェクト削除は非同期で実行される | E-01（27行目: async_execute） | ○ |
| C-07 | 削除エラーはDestroyErrorとして処理される | E-01（31-32行目: rescue Projects::DestroyService::DestroyError） | ○ |
| C-08 | プロジェクト移行はTransferServiceで実行される | E-01（38行目: Projects::TransferService） | ○ |
| C-09 | 移行エラーはnew_namespaceエラーとして表示される | E-01（40行目: @project.errors[:new_namespace]） | ○ |
| C-10 | プロジェクト更新はUpdateServiceで実行される | E-01（50行目: Projects::UpdateService） | ○ |
| C-11 | Runner登録無効化時に登録トークンをリセット | E-01（53-55行目） | ○ |
| C-12 | リポジトリチェックはSingleRepositoryWorkerで実行 | E-01（65行目: RepositoryCheck::SingleRepositoryWorker.perform_async） | ○ |
| C-13 | 編集可能なパラメータはname, description, runner_registration_enabled | E-01（90-95行目: allowed_project_params） | ○ |
| C-14 | トースト通知で削除結果を表示 | E-01（28行目: flash[:toast]） | ○ |
| C-15 | 関連画面No.236-238が存在する | E-03（236-238行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクト移行時の権限チェックが適切か確認
- [ ] プロジェクト削除の非同期処理が完了通知を含むか確認
- [ ] リポジトリチェックの結果確認方法を確認
