---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：114-アプリケーション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **EE追加パネルの詳細**：Enterprise Edition固有の設定パネル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/application_settings_controller.rb` - アプリケーション設定コントローラー
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | 設定パネルは動的に定義されている | E-01（43-46行目: VALID_SETTING_PANELS、54-56行目: define_method） | ○ |
| C-03 | キャッシュをバイパスして設定を取得 | E-01（142行目: ApplicationSetting.current_without_cache） | ○ |
| C-04 | OAuth設定をdisabled形式に変換 | E-01（153-159行目） | ○ |
| C-05 | 空のテンプレートをnilに変換 | E-01（171-173行目） | ○ |
| C-06 | Runner登録トークンリセットが可能 | E-01（88-93行目） | ○ |
| C-07 | ヘルスチェックトークンリセットが可能 | E-01（95-99行目） | ○ |
| C-08 | エラートラッキングトークンリセットが可能 | E-01（101-106行目） | ○ |
| C-09 | リポジトリチェック状態クリアが可能 | E-01（115-122行目） | ○ |
| C-10 | Let's Encrypt利用規約へリダイレクト | E-01（127-129行目） | ○ |
| C-11 | Slack Manifest共有が可能 | E-01（131-133行目） | ○ |
| C-12 | Slack Manifestダウンロードが可能 | E-01（135-137行目） | ○ |
| C-13 | インテグレーション一覧を取得 | E-01（58-64行目） | ○ |
| C-14 | Service Pingデータを表示/ダウンロード可能 | E-01（70-86行目） | ○ |
| C-15 | usage_data表示時にQuery Limitingを無効化 | E-01（146-148行目: disable_query_limiting） | ○ |
| C-16 | Service Pingダウンロード時にInternal Eventを記録 | E-01（81行目: Gitlab::InternalEvents.track_event） | ○ |
| C-17 | ApplicationSettings::UpdateServiceで更新処理 | E-01（231-233行目） | ○ |
| C-18 | EE追加パネルの詳細 | **根拠なし**（EEモジュール未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- Enterprise Edition固有の設定パネル
  - 候補：`ee/app/controllers/admin/application_settings_controller.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の実装は明確に確認できる
- 1: 中リスク - EE固有機能は別途確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] 設定変更の影響範囲（全インスタンス）を確認
- [ ] 機密情報（APIキー等）の取り扱いが適切か確認
- [ ] キャッシュの整合性（current_without_cacheの使用箇所）を確認
