---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：115-ランナー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/runners_controller.rb` - Runner管理コントローラー
- E-02: `app/models/ci/runner.rb` - Runnerモデル
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | タグ検索上限は20件 | E-01（6行目: TAGS_LIMIT = 20） | ○ |
| C-03 | Ci::Runner.findでRunner取得 | E-01（54行目） | ○ |
| C-04 | 編集時にassign_projectsを呼び出す | E-01（21行目） | ○ |
| C-05 | 登録可否をregistration_available?でチェック | E-01（27行目） | ○ |
| C-06 | UpdateRunnerServiceで更新処理 | E-01（31行目） | ○ |
| C-07 | Ci::TagsFinderでタグ検索 | E-01（42行目） | ○ |
| C-08 | private_runner_setup_scriptsでスクリプト生成 | E-01（48行目） | ○ |
| C-09 | 編集可能な属性はFORM_EDITABLEで定義 | E-02（91行目） | ○ |
| C-10 | Gitlab.comの場合のみコストファクター編集可能 | E-01（62-66行目: permitted_attrs） | ○ |
| C-11 | プロジェクト検索はsearchパラメータがある場合のみ | E-01（71-72行目） | ○ |
| C-12 | 既存割り当てプロジェクトを除外 | E-01（77-78行目: id_not_in） | ○ |
| C-13 | プロジェクト一覧は30件/ページ、カウントなし | E-01（80行目: per(30).without_count） | ○ |
| C-14 | 登録可能時間は1時間 | E-02（82行目: REGISTRATION_AVAILABILITY_TIME = 1.hour） | ○ |
| C-15 | タグは最大50個 | E-02（94行目: TAG_LIST_MAX_LENGTH = 50） | ○ |
| C-16 | 関連画面No.258-261が存在する | E-04（258-261行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] Runner登録トークンの有効期限（1時間）が運用要件に適合しているか確認
- [ ] タグ数上限（50個）が運用要件に適合しているか確認
- [ ] Gitlab.com固有のコストファクター設定の影響を確認
