---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：116-ジョブ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/jobs_controller.rb` - ジョブ管理コントローラー
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | ページあたり30件 | E-01（4行目: BUILDS_PER_PAGE = 30） | ○ |
| C-03 | feature flagでRunnerタイプフィルタを制御 | E-01（10行目: push_frontend_feature_flag(:admin_jobs_filter_runner_type)） | ○ |
| C-04 | indexアクションで一覧表示 | E-01（13行目） | ○ |
| C-05 | cancel_allでrunning_or_pendingのジョブをキャンセル | E-01（15-16行目） | ○ |
| C-06 | キャンセル後にsee_otherでリダイレクト | E-01（18行目: status: :see_other） | ○ |
| C-07 | feature_categoryはcontinuous_integration | E-01（6行目） | ○ |
| C-08 | 関連画面No.262が存在する | E-03（262行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] 一括キャンセル操作の確認ダイアログが実装されているか確認
- [ ] 大量ジョブキャンセル時のパフォーマンス影響を確認
