---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 8
  claims_with_evidence: 6
  claims_without_evidence: 2
confidence_derived: 0.75
---

# 根拠レポート：117-バックグラウンドジョブ監視

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.75**
  - 根拠あり：6 / 8、根拠なし：2
- 優先レビュー（高）
  1. **バックグラウンドマイグレーション関連コントローラーの詳細**：別コントローラーの詳細未確認
  2. **Sidekiq Web UIのマウント設定**：routes設定の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/background_jobs_controller.rb` - バックグラウンドジョブコントローラー
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | feature_categoryはnot_owned | E-01（5行目） | ○ |
| C-03 | コントローラーは非常にシンプル | E-01（全体構造） | ○ |
| C-04 | 関連画面No.222, 272-274が存在する | E-03 | ○ |
| C-05 | 機能一覧にバックグラウンドジョブ監視が存在 | E-02（117行目） | ○ |
| C-06 | Sidekiqジョブの監視機能 | E-02（117行目説明） | ○ |
| C-07 | バックグラウンドマイグレーション関連の詳細処理 | **根拠なし**（別コントローラー未確認） | △ |
| C-08 | Sidekiq Web UIのマウント設定 | **根拠なし**（routes/initializers未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- バックグラウンドマイグレーション関連コントローラー
  - 候補：`app/controllers/admin/background_migrations_controller.rb`
- Sidekiq Web UIのルーティング設定
  - 候補：`config/routes/admin.rb` / `config/initializers/sidekiq.rb`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - コントローラーが非常にシンプルで、実装の多くが他のファイルに依存
- 1: 中リスク - Sidekiq Web UIの認証設定の確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] Sidekiq Web UIへのアクセス認証が適切に設定されているか確認
- [ ] バックグラウンドマイグレーションの進捗表示が正確か確認
- [ ] Redis接続エラー時の挙動を確認
