---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：118-ブロードキャストメッセージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/broadcast_messages_controller.rb` - ブロードキャストメッセージコントローラー
- E-02: `app/models/system/broadcast_message.rb` - ブロードキャストメッセージモデル
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | メッセージタイプはbannerとnotification | E-02（55-58行目: enum :broadcast_type） | ○ |
| C-03 | テーマは10種類 | E-02（42-53行目: enum :theme） | ○ |
| C-04 | 許可されるアクセスレベルはGUEST〜OWNER | E-02（8-15行目: ALLOWED_TARGET_ACCESS_LEVELS） | ○ |
| C-05 | キャッシュキーが定義されている | E-02（36-38行目: CACHE_KEY等） | ○ |
| C-06 | after_commitでキャッシュフラッシュ | E-02（40行目: after_commit :flush_redis_cache） | ○ |
| C-07 | デフォルトカラーは#E75E40, #FFFFFF | E-02（29-30行目: attribute :color, :font） | ○ |
| C-08 | パスマッチングはワイルドカード対応 | E-02（144-158行目: matches_current_path） | ○ |
| C-09 | キャッシュ有効期間は2週間 | E-02（89-91行目: cache_expires_in = 2.weeks） | ○ |
| C-10 | show_in_cliでCLI表示を制御 | E-02（24行目: validates :show_in_cli） | ○ |
| C-11 | 一覧はends_at降順でソート | E-01（83行目: order(ends_at: :desc)） | ○ |
| C-12 | JSON/HTML両方に対応 | E-01（23-38行目, 44-58行目） | ○ |
| C-13 | プレビュー機能がある | E-01（71-74行目） | ○ |
| C-14 | 許可パラメータが適切に定義されている | E-01（86-98行目: broadcast_message_params） | ○ |
| C-15 | dismissableパラメータが存在する | E-01（95行目） | ○ |
| C-16 | target_access_levelsはデフォルト空配列 | E-01（97行目: reverse_merge!) | ○ |
| C-17 | 関連画面No.250-251が存在する | E-04 | ○ |
| C-18 | feature_categoryはnotifications | E-01（10行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] パスマッチングのワイルドカード処理が安全か確認
- [ ] キャッシュのフラッシュタイミングが適切か確認
- [ ] XSS対策のサニタイズ処理が適切か確認
