---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：119-デプロイキー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/deploy_keys_controller.rb` - デプロイキー管理コントローラー
- E-02: `app/models/deploy_key.rb` - デプロイキーモデル
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | 公開デプロイキーのみ管理 | E-01（54行目: DeployKey.are_public） | ○ |
| C-03 | are_publicスコープで公開キーを取得 | E-02（24行目: scope :are_public） | ○ |
| C-04 | DeployKeys::CreateServiceで作成 | E-01（17-18行目） | ○ |
| C-05 | 作成時にpublic: trueを設定 | E-01（18行目: merge(public: true)） | ○ |
| C-06 | 作成時に組織を設定 | E-01（18行目: organization: Current.organization） | ○ |
| C-07 | 編集ではタイトルのみ変更可能 | E-01（62行目: update_params - :title only） | ○ |
| C-08 | 作成時のパラメータはtitle, key, expires_at | E-01（58行目: create_params） | ○ |
| C-09 | JSON/HTML両方に対応（削除時） | E-01（41-44行目） | ○ |
| C-10 | feature_categoryはcontinuous_delivery | E-01（7行目） | ○ |
| C-11 | DeployKeyはKeyを継承 | E-02（3行目: class DeployKey < Key） | ○ |
| C-12 | has_manyでdeploy_keys_projectsを持つ | E-02（11行目） | ○ |
| C-13 | 関連画面No.255-257が存在する | E-04 | ○ |
| C-14 | 有効期限（expires_at）を設定可能 | E-01（58行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] SSH公開鍵のバリデーションが適切か確認
- [ ] 有効期限切れキーの扱いを確認
- [ ] キー削除時のプロジェクト影響を確認
