---
generated_at: 2026-01-22 12:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：12-グループ移行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **サブスクリプション制限の詳細**：EE機能の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - GroupsController
- E-02: `app/services/groups/transfer_service.rb` - TransferService
- E-03: `app/models/group.rb` - Groupモデル
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 元グループの変更権限が必要 | E-01 (24行目: authorize_change_group!) | ○ |
| C-02 | 移行先での作成権限が必要 | E-02 (162-170行目: valid_policies?) | ○ |
| C-03 | 既にルートグループの場合は移行不可 | E-02 (145-147行目: group_is_already_root?) | ○ |
| C-04 | 同じ親グループへは移行不可 | E-02 (149-151行目: same_parent?) | ○ |
| C-05 | パス重複時は移行不可 | E-02 (173-176行目: namespace_with_same_path?) | ○ |
| C-06 | コンテナイメージ存在時は移行不可 | E-02 (178-180行目: group_projects_contain_registry_images?) | ○ |
| C-07 | サブグループへの移行は不可 | E-02 (157-160行目: transfer_to_subgroup?) | ○ |
| C-08 | NPMパッケージ制限 | E-02 (130-139行目: group_with_namespaced_npm_packages?) | ○ |
| C-09 | CRM権限チェック | E-02 (119-128行目: no_permissions_to_migrate_crm?) | ○ |
| C-10 | 可視性レベルの自動調整 | E-02 (183-186行目: visibility_level調整) | ○ |
| C-11 | 2FA設定の継承 | E-02 (233-239行目: update_two_factor_authentication) | ○ |
| C-12 | グループ属性の保存 | E-02 (196-198行目: group.save!) | ○ |
| C-13 | オーナー確保 | E-02 (253-263行目: ensure_ownership) | ○ |
| C-14 | インテグレーション更新 | E-02 (301-304行目: update_integrations) | ○ |
| C-15 | CRMオブジェクト移行 | E-02 (320-327行目: update_crm_objects) | ○ |
| C-16 | イベント発行 | E-02 (329-339行目: publish_event) | ○ |
| C-17 | ラベル移行 | E-02 (89-95行目: transfer_labels) | ○ |
| C-18 | 権限再計算 | E-02 (265-269行目: refresh_project_authorizations) | ○ |
| C-19 | インテグレーション伝播 | E-02 (306-310行目: propagate_integrations) | ○ |
| C-20 | ペンディングビルド更新 | E-02 (312-318行目: update_pending_builds) | ○ |
| C-21 | 共有Runner設定継承 | E-02 (290-299行目: inherit_group_shared_runners_settings) | ○ |
| C-22 | エラーメッセージ一覧 | E-02 (276-288行目: localized_error_messages) | ○ |
| C-23 | トランザクション管理 | E-02 (63-73行目: Group.transaction) | ○ |
| C-24 | 関連画面: グループ編集 | E-05 (画面No 143) | ○ |
| C-25 | 機能カテゴリ: グループ管理 | E-04 (No.12) | ○ |
| C-26 | コントローラーのtransferアクション | E-01 (235-246行目) | ○ |
| C-27 | 子グループの可視性更新 | E-02 (204-229行目: update_children_and_projects_visibility) | ○ |
| C-28 | サブスクリプション制限（has_subscription?） | **根拠なし（EE機能）** | △ |

## 4) 不足情報（Unknown / Missing）
- サブスクリプション制限の詳細仕様
  - 候補：`ee/app/services/groups/transfer_service.rb` / EE拡張

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェックロジック - 十分なカバレッジあり
- 0: 移行可否チェックロジック - 網羅的に検証済み
- 1: EE固有の制限事項 - CE/EE差分の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェック（change_group, create_subgroup）の実装が適切か確認
- [ ] 移行可否チェック条件が網羅的か確認
- [ ] トランザクション範囲が適切か確認
- [ ] GroupTransferedEventのサブスクライバーを確認
- [ ] EE拡張（has_subscription?等）の影響を確認
