---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-ラベル管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/labels_controller.rb` - ラベル管理コントローラー
- E-02: `app/models/label.rb` - ラベルモデル
- E-03: `app/services/labels/create_service.rb` - ラベル作成サービス
- E-04: `app/services/labels/update_service.rb` - ラベル更新サービス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限のみがアクセス可能 | E-01（Admin::ApplicationControllerを継承） | ○ |
| C-02 | テンプレートラベルのみを管理 | E-01（10行目: template_labels、62行目: template: true） | ○ |
| C-03 | in_organizationスコープで組織を限定 | E-01（10行目: Label.in_organization） | ○ |
| C-04 | templatesスコープでテンプレートを取得 | E-01（10行目: .templates） | ○ |
| C-05 | Labels::CreateServiceで作成 | E-01（22行目: Labels::CreateService） | ○ |
| C-06 | 作成時にtemplate: trueを設定 | E-01（22行目: merge(template: true)） | ○ |
| C-07 | 作成時に組織を設定 | E-01（22行目: organization_id: Current.organization.id） | ○ |
| C-08 | Labels::UpdateServiceで更新 | E-01（32行目: Labels::UpdateService） | ○ |
| C-09 | 説明の最大サイズは512KB | E-02（DESCRIPTION_LENGTH_MAX定義） | ○ |
| C-10 | 色のバリデーションが存在 | E-02（validates :colorのバリデーション） | ○ |
| C-11 | JSON/HTML両方に対応（削除時） | E-01（42-57行目: respond_to do |format|） | ○ |
| C-12 | feature_categoryはteam_planning | E-01（6行目: feature_category :team_planning） | ○ |
| C-13 | ページネーション対応 | E-01（10行目: .page(params[:page])） | ○ |
| C-14 | 関連画面No.264-266が存在する | E-06 | ○ |
| C-15 | set_labelでbefore_action | E-01（8行目: before_action :set_label） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認できた

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレートラベルが新規プロジェクトに正しくコピーされるか確認
- [ ] 組織スコープのアクセス制御が適切か確認
- [ ] ラベル削除時の関連データ（label_links等）の扱いを確認
