---
generated_at: 2026-01-22 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：121-ユーザーダッシュボード機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ホームページデータの詳細構造**：HomepageData concernの具体的な実装詳細
  2. **EE版追加機能の詳細**：prepend_mod_withによる拡張内容

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/dashboard_controller.rb` - メインコントローラー（132行）
- E-02: `app/finders/user_recent_events_finder.rb` - ユーザーイベントファインダー（91行）
- E-03: `app/finders/projects_finder.rb` - プロジェクトファインダー（348行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | homeアクションでpersonal_homepageフラグをチェックする | E-01 (37-44行目) | ○ |
| C-02 | activityアクションでHTML/JSON両形式に対応 | E-01 (47-56行目) | ○ |
| C-03 | filterパラメータでyour_projects/projects/starred/followedを指定可能 | E-01 (66-73行目) | ○ |
| C-04 | load_project_eventsでProjectsFinderを使用 | E-01 (82-102行目) | ○ |
| C-05 | load_user_eventsでUserRecentEventsFinderを使用 | E-01 (78-80行目) | ○ |
| C-06 | UserRecentEventsFinderのDEFAULT_LIMITは20 | E-02 (20行目) | ○ |
| C-07 | UserRecentEventsFinderのMAX_LIMITは100 | E-02 (21行目) | ○ |
| C-08 | 認証済みユーザーのみアクセス可能 | E-01 (prepend_before_action) | ○ |
| C-09 | RSS/ICSでセッションレス認証をサポート | E-01 (9-10行目) | ○ |
| C-10 | feature_categoryがnotificationsに設定（home） | E-01 (29行目) | ○ |
| C-11 | urgencyがlowに設定 | E-01 (34-35行目) | ○ |
| C-12 | フィルタ未設定時のAtomフォーマットでbad_request | E-01 (124-127行目) | ○ |
| C-13 | global_time_tracking_reportフラグをactivityでpush | E-01 (23-25行目) | ○ |
| C-14 | EE版でprepend_mod_withによる拡張 | E-01 (131行目) | ○ |
| C-15 | フォローしているユーザーの活動を取得可能 | E-02 (execute_multi) | ○ |
| C-16 | イベントは閲覧権限チェックを経て表示 | E-02 (41, 53行目) | ○ |
| C-17 | homepage_app_dataの具体的な構造 | **根拠なし** | △ |
| C-18 | EE版での追加ダッシュボード機能の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- HomepageData concernの実装詳細が未確認
  - 候補：`app/controllers/concerns/homepage_data.rb` の読み込みが必要
- EE版拡張機能の詳細
  - 候補：`ee/app/controllers/ee/dashboard_controller.rb` の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは全てソースコードで確認済み
- 1: 中リスク - ホームページデータの構造詳細はconcernファイルの確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] DashboardController.rbの37-45行目（homeアクション）が設計書の記述と一致するか
- [ ] UserRecentEventsFinderのDEFAULT_LIMIT/MAX_LIMITが正確か
- [ ] 画面機能マッピング.csvとの関連画面の整合性を確認
- [ ] HomepageData concernの実装を確認し、homepage_app_dataの構造を補完
