---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：122-グループダッシュボード機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **GroupTree concernの詳細実装**：グループツリーレンダリングの具体的な実装

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/dashboard/groups_controller.rb` - グループダッシュボードコントローラー（23行）
- E-02: `app/finders/groups_finder.rb` - グループファインダー（210行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでGroupsFinderを使用 | E-01 (13-18行目) | ○ |
| C-02 | all_available: falseで権限付きグループのみ取得 | E-01 (15行目), E-02 (204-206行目) | ○ |
| C-03 | Current.organizationでスコープ制御 | E-01 (16行目) | ○ |
| C-04 | activeパラメータでアクティブフィルタ | E-01 (17行目), E-02 (177-181行目) | ○ |
| C-05 | feature_categoryがgroups_and_projects | E-01 (8行目) | ○ |
| C-06 | urgencyがlow | E-01 (10行目) | ○ |
| C-07 | skip_cross_project_access_checkを適用 | E-01 (6行目) | ○ |
| C-08 | GroupTree concernでツリーレンダリング | E-01 (4, 20行目) | ○ |
| C-09 | GroupsFinderでowned_groupsフィルタ対応 | E-02 (62, 76-78行目) | ○ |
| C-10 | GroupsFinderでmin_access_levelフィルタ対応 | E-02 (63, 81-89行目) | ○ |
| C-11 | with_routeスコープ適用 | E-02 (50行目) | ○ |
| C-12 | by_organization, by_activeなどのフィルタチェーン | E-02 (109-122行目) | ○ |
| C-13 | include_ancestorsデフォルトtrue | E-02 (94行目) | ○ |
| C-14 | GroupTree concernの詳細なレンダリングロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GroupTree concernの実装詳細が未確認
  - 候補：`app/controllers/concerns/group_tree.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとファインダーの主要ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Dashboard::GroupsController.rbのindexアクションが設計書の記述と一致するか
- [ ] GroupsFinderのall_available: falseの動作を確認
- [ ] GroupTree concernのrender_group_tree実装を確認
- [ ] 画面機能マッピング.csvとの整合性を確認
