---
generated_at: 2026-01-22 13:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：123-プロジェクトダッシュボード機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **RendersProjectsList concernの詳細実装**：プロジェクト一覧レンダリングの具体的な実装

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/dashboard/projects_controller.rb` - プロジェクトダッシュボードコントローラー（61行）
- E-02: `app/finders/projects_finder.rb` - プロジェクトファインダー（348行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでHTML/Atom両形式に対応 | E-01 (23-31行目) | ○ |
| C-02 | personal=trueでpersonal_dashboard_projects_pathへリダイレクト | E-01 (20行目) | ○ |
| C-03 | archived=onlyでinactive_dashboard_projects_pathへリダイレクト | E-01 (21行目) | ○ |
| C-04 | セッションレス認証でRSS対応 | E-01 (11行目) | ○ |
| C-05 | feature_categoryがgroups_and_projects | E-01 (16行目) | ○ |
| C-06 | urgencyがlow | E-01 (17行目) | ○ |
| C-07 | load_eventsでProjectsFinderを使用 | E-01 (37-39行目) | ○ |
| C-08 | non_public: trueとnot_aimed_for_deletion: trueを設定 | E-01 (38行目) | ○ |
| C-09 | EventCollectionでイベント集約 | E-01 (41-43行目) | ○ |
| C-10 | Events::RenderServiceでレンダリング | E-01 (45行目) | ○ |
| C-11 | デフォルトソートはsort_value_name | E-01 (48-50行目) | ○ |
| C-12 | SORTING_PREFERENCE_FIELDでソート設定永続化 | E-01 (52-54行目) | ○ |
| C-13 | set_non_archived_paramでアーカイブ除外 | E-01 (12行目) | ○ |
| C-14 | skip_cross_project_access_check適用 | E-01 (14行目) | ○ |
| C-15 | ProjectsFinderで各種フィルタ適用 | E-02 (85-110行目) | ○ |
| C-16 | RendersProjectsList concernの詳細なレンダリングロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RendersProjectsList concernの実装詳細が未確認
  - 候補：`app/controllers/concerns/renders_projects_list.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとファインダーの主要ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Dashboard::ProjectsController.rbのindexアクションが設計書の記述と一致するか
- [ ] リダイレクト条件（personal, archived）が正確か
- [ ] ProjectsFinderのフィルタ適用順序を確認
- [ ] RendersProjectsList concernの実装を確認
- [ ] 画面機能マッピング.csvとの整合性を確認
