---
generated_at: 2026-01-22 13:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：124-Todoリスト機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **TodoServiceの詳細実装**：Todo作成ロジックの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/dashboard/todos_controller.rb` - Todoコントローラー（16行）
- E-02: `app/finders/todos_finder.rb` - Todoファインダー（283行）
- E-03: `app/models/todo.rb` - Todoモデル（544行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでtrack_internal_event実行 | E-01 (10-13行目) | ○ |
| C-02 | feature_categoryがnotifications | E-01 (6行目) | ○ |
| C-03 | urgencyがlow | E-01 (7行目) | ○ |
| C-04 | アクション種別定数（ASSIGNED=1, MENTIONED=2等） | E-03 (14-31行目) | ○ |
| C-05 | state_machineでpending/done状態管理 | E-03 (118-125行目) | ○ |
| C-06 | polymorphic associationでtarget参照 | E-03 (64-70行目) | ○ |
| C-07 | TODO_TYPESで許可種別定義 | E-02 (28-31行目) | ○ |
| C-08 | stateデフォルトはpending | E-02 (273-275行目) | ○ |
| C-09 | pending時はnot_snoozed適用 | E-02 (241-246行目) | ○ |
| C-10 | without_hiddenでBAN済みユーザー除外 | E-02 (262-267行目), E-03 (112-114行目) | ○ |
| C-11 | sort_by_snoozed_and_creation_datesソート | E-03 (215-231行目) | ○ |
| C-12 | order_by_labels_priorityソート | E-03 (236-267行目) | ○ |
| C-13 | batch_updateで一括更新 | E-03 (181-194行目) | ○ |
| C-14 | resolved_by_action enumで完了理由記録 | E-03 (116行目) | ○ |
| C-15 | by_action_id, by_action等のフィルタメソッド | E-02 (186-210行目) | ○ |
| C-16 | by_group でgroup_ids_and_descendantsフィルタ | E-02 (228-232行目), E-03 (133-146行目) | ○ |
| C-17 | keyset paginationサポート | E-03 (209, 245行目) | ○ |
| C-18 | WAIT_FOR_DELETE = 1.hour定義 | E-03 (11行目) | ○ |
| C-19 | EE版で追加アクション種別 | E-03 (33行目コメント) | ○ |
| C-20 | TodoServiceのTodo作成ロジック詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TodoServiceの実装詳細が未確認
  - 候補：`app/services/todo_service.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデルとファインダーの主要ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Todoモデルのアクション種別定数が最新か確認
- [ ] TodosFinderのフィルタ適用順序が正確か確認
- [ ] スヌーズソートロジックの動作確認
- [ ] TodoServiceのTodo作成ロジックを確認
- [ ] 画面機能マッピング.csvとの整合性を確認
