---
generated_at: 2026-01-22 13:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：125-コントリビューションアナリティクス機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RepositoryLanguagesServiceの詳細実装**：言語構成取得ロジックの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/graphs_controller.rb` - グラフコントローラー（122行）
- E-02: `lib/gitlab/graphs/commits.rb` - コミット統計クラス（52行）
- E-03: `app/finders/ci/daily_build_group_report_results_finder.rb` - カバレッジファインダー（102行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MAX_COMMITS = 6000 | E-01 (24行目) | ○ |
| C-02 | charts_limit = 2000 | E-01 (71行目) | ○ |
| C-03 | skip_merges: trueでマージコミット除外 | E-01 (32, 72行目) | ○ |
| C-04 | feature_categoryがsource_code_management | E-01 (18行目) | ○ |
| C-05 | urgencyがlow | E-01 (19, 22行目) | ○ |
| C-06 | require_non_empty_project前提条件 | E-01 (8行目) | ○ |
| C-07 | authorize_read_repository_graphs!権限チェック | E-01 (10行目) | ○ |
| C-08 | track_event (p_analytics_repo)追跡 | E-01 (12-16行目) | ○ |
| C-09 | commits_per_week_days統計 | E-02 (27-29, 40-42行目) | ○ |
| C-10 | commits_per_time統計（0-23時） | E-02 (30-31, 43-45行目) | ○ |
| C-11 | commits_per_month統計（1-31日） | E-02 (33-34, 46-47行目) | ○ |
| C-12 | commit_per_day計算 | E-02 (22-24行目) | ○ |
| C-13 | authorsカウント（ユニークメールアドレス） | E-02 (18-20行目) | ○ |
| C-14 | カバレッジ期間90日 | E-03 (24行目 REPORT_WINDOW = 90.days) | ○ |
| C-15 | get_languages で言語構成取得 | E-01 (79-84行目) | ○ |
| C-16 | get_daily_coverage_options でカバレッジ設定 | E-01 (86-110行目) | ○ |
| C-17 | commits/languagesアクションはchartsへリダイレクト | E-01 (46-52行目) | ○ |
| C-18 | RepositoryLanguagesServiceの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Projects::RepositoryLanguagesServiceの実装詳細が未確認
  - 候補：`app/services/projects/repository_languages_service.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーと統計計算ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_COMMITS, commits_limitの値が正確か確認
- [ ] Gitlab::Graphs::Commitsの統計計算ロジック確認
- [ ] カバレッジ期間90日が最新か確認
- [ ] RepositoryLanguagesServiceの実装を確認
- [ ] 画面機能マッピング.csvとの整合性を確認
