---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：126-リポジトリアナリティクス機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **RepositoryLanguagesServiceの詳細実装**：言語取得ロジックの確認
  2. **Linguist連携の詳細**：言語検出メカニズムの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/graphs_controller.rb` - グラフコントローラー（79-84行目）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_languagesでRepositoryLanguagesService呼び出し | E-01 (79-84行目) | ○ |
| C-02 | 言語情報にvalue, label, color, highlightを含む | E-01 (82行目) | ○ |
| C-03 | repository_languagesテーブルで言語構成キャッシュ | コード構造から推定 | ○ |
| C-04 | programming_languagesテーブルで言語マスタ管理 | コード構造から推定 | ○ |
| C-05 | 機能一覧での説明（言語、コミット頻度等の分析） | E-03 | ○ |
| C-06 | 画面機能マッピングでの関連画面 | E-02 | ○ |
| C-07 | shareは0-100のパーセント値 | E-01 (82行目: lang.share) | ○ |
| C-08 | colorは言語表示色 | E-01 (82行目: lang.color) | ○ |
| C-09 | GitHub Linguistベースの言語検出 | 業界標準知識 | ○ |
| C-10 | .gitattributesでカスタム設定可能 | Linguist仕様 | ○ |
| C-11 | 非同期ワーカーでの言語検出 | コード構造から推定 | ○ |
| C-12 | 管理者向けコホート分析機能 | E-02 (画面No.267) | ○ |
| C-13 | RepositoryLanguagesServiceの詳細実装 | **根拠なし** | △ |
| C-14 | Linguist連携の具体的実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Projects::RepositoryLanguagesServiceの実装詳細が未確認
  - 候補：`app/services/projects/repository_languages_service.rb` の読み込みが必要
- Gitlab::LanguageDetectionの実装詳細が未確認
  - 候補：`lib/gitlab/language_detection.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 言語検出の具体的な実装詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] RepositoryLanguagesServiceの実装を確認
- [ ] LanguageDetectionの実装を確認
- [ ] repository_languagesテーブルのスキーマ確認
- [ ] 画面機能マッピング.csvとの整合性を確認
