---
generated_at: 2026-01-22 13:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：127-CI/CDアナリティクス機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **DailyBuildGroupReportResultモデルの詳細**：PARAM_TYPESの定義確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/ci/daily_build_group_report_results_controller.rb` - コントローラー（67行）
- E-02: `app/finders/ci/daily_build_group_report_results_finder.rb` - ファインダー（102行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでCSV/JSON分岐 | E-01 (10-14行目) | ○ |
| C-02 | authorize_read_build_report_results!権限チェック | E-01 (4行目) | ○ |
| C-03 | validate_param_type!でパラメータ検証 | E-01 (5, 18-20行目) | ○ |
| C-04 | feature_categoryがcode_testing | E-01 (7行目) | ○ |
| C-05 | MAX_ITEMS = 1000 | E-02 (23行目) | ○ |
| C-06 | REPORT_WINDOW = 90日 | E-02 (24行目) | ○ |
| C-07 | start_dateの90日制限ロジック | E-02 (82-91行目) | ○ |
| C-08 | by_coverage, by_ref_path, by_datesフィルタ | E-02 (56-65行目) | ○ |
| C-09 | sortとlimit_byの適用 | E-02 (68-74行目) | ○ |
| C-10 | ref_path未指定時はwith_default_branch | E-02 (61行目) | ○ |
| C-11 | CsvBuilderでCSV生成 | E-01 (22-31行目) | ○ |
| C-12 | DailyBuildGroupReportResultSerializerでJSON生成 | E-01 (33-35行目) | ○ |
| C-13 | finder_paramsでフィルタ条件設定 | E-01 (44-53行目) | ○ |
| C-14 | PARAM_TYPESで許可種別定義 | E-01 (55-57行目) | ○ |
| C-15 | DATE_FORMAT_ALLOWED = '%Y-%m-%d' | E-02 (25行目) | ○ |
| C-16 | DailyBuildGroupReportResultモデルの詳細構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Ci::DailyBuildGroupReportResultモデルの実装詳細が未確認
  - 候補：`app/models/ci/daily_build_group_report_result.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとファインダーの主要ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] MAX_ITEMS, REPORT_WINDOWの値が正確か確認
- [ ] PARAM_TYPESの定義をモデルで確認
- [ ] 日付範囲フィルタの動作確認
- [ ] 画面機能マッピング.csvとの整合性を確認
