---
generated_at: 2026-01-22 13:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：128-バリューストリームアナリティクス機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **StageSummaryの詳細実装**：サマリー計算ロジックの確認
  2. **DefaultStagesの定義**：7ステージの詳細定義

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/cycle_analytics_controller.rb` - コントローラー（86行）
- E-02: `app/models/analytics/cycle_analytics/project_level.rb` - ProjectLevel（53行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | showアクションでHTML/JSON分岐 | E-01 (40-50行目) | ○ |
| C-02 | authorize_read_cycle_analytics!権限チェック | E-01 (12行目) | ○ |
| C-03 | feature_categoryがvalue_stream_management | E-01 (20行目) | ○ |
| C-04 | urgencyがlow | E-01 (21行目) | ○ |
| C-05 | track_event (p_analytics_valuestream)追跡 | E-01 (14-18行目) | ○ |
| C-06 | InternalEvents.track_event('view_cycle_analytics')呼び出し | E-01 (42行目) | ○ |
| C-07 | Analytics::CycleAnalytics::ProjectLevel使用 | E-01 (34-37行目), E-02 | ○ |
| C-08 | summaryメソッドでStageSummary使用 | E-02 (13-18行目) | ○ |
| C-09 | statsメソッドでステージ統計計算 | E-02 (25-29行目) | ○ |
| C-10 | permissionsメソッドで権限情報取得 | E-02 (21-23行目) | ○ |
| C-11 | default_stage_namesでデフォルトステージ取得 | E-02 (46-48行目) | ○ |
| C-12 | value_streamでデフォルトValueStream使用 | E-01 (59-62行目) | ○ |
| C-13 | CycleAnalyticsParams concern使用 | E-01 (6行目) | ○ |
| C-14 | GracefulTimeoutHandling concern使用 | E-01 (7行目) | ○ |
| C-15 | EE版でprepend_mod拡張 | E-01 (85行目), E-02 (52行目) | ○ |
| C-16 | ライセンス機能のプッシュ | E-01 (23-31行目) | ○ |
| C-17 | StageSummaryの詳細計算ロジック | **根拠なし** | △ |
| C-18 | DefaultStagesの7ステージ定義詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitlab::CycleAnalytics::StageSummaryの実装詳細が未確認
  - 候補：`lib/gitlab/cycle_analytics/stage_summary.rb` の読み込みが必要
- Gitlab::Analytics::CycleAnalytics::DefaultStagesの定義が未確認
  - 候補：`lib/gitlab/analytics/cycle_analytics/default_stages.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - サマリー計算とステージ定義の詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] StageSummaryの計算ロジックを確認
- [ ] DefaultStagesの7ステージ定義を確認
- [ ] GracefulTimeoutHandlingの動作確認
- [ ] 画面機能マッピング.csvとの整合性を確認
