---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：13-サブグループ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **階層制限の具体的な値**：設定ファイルまたはシステム設定の確認が必要
  2. **Groups::CreateServiceの詳細**：サービスファイルの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - GroupsController
- E-02: `app/models/group.rb` - Groupモデル
- E-03: `app/models/namespace.rb` - Namespaceモデル（参照予定）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 親グループでのcreate_subgroup権限が必要 | E-01 (316-327行目: authorize_create_group!) | ○ |
| C-02 | subgroup_creation_levelにより作成可能ロールを制限 | E-02 (1017-1020行目: subgroup_creation_level) | ○ |
| C-03 | 可視性は親グループ以下でなければならない | E-02 (663-681行目: visibility_level_allowed_by_parent?) | ○ |
| C-04 | 親グループで2FAが許可されていない場合、サブグループでも有効化不可 | E-02 (1090-1095行目: parent_allows_two_factor_authentication?) | ○ |
| C-05 | 同一親グループ内でパスは一意 | E-02 (バリデーション) | ○ |
| C-06 | グループ名は命名規則に準拠 | E-02 (226-232行目: validates :name) | ○ |
| C-07 | 共有Runner設定を継承 | E-02 (デフォルト設定) | ○ |
| C-08 | GroupsController#newで親グループ取得 | E-01 (77-81行目) | ○ |
| C-09 | GroupsController#createでGroups::CreateService呼び出し | E-01 (83-109行目) | ○ |
| C-10 | 作成成功時にサブグループページにリダイレクト | E-01 (105行目: redirect_to @group) | ○ |
| C-11 | 作成失敗時にnewテンプレートを再表示 | E-01 (107行目: render action: "new") | ○ |
| C-12 | システムフックの実行 | E-02 (810-814行目: post_create_hook) | ○ |
| C-13 | 親グループの存在チェック | E-01 (78行目: Group.find_by_id) | ○ |
| C-14 | 関連画面: グループ詳細 | E-05 (画面No 141) | ○ |
| C-15 | 関連画面: グループ新規作成 | E-05 (画面No 142) | ○ |
| C-16 | 機能カテゴリ: グループ管理 | E-04 (No.13) | ○ |
| C-17 | Mattermostチーム連携 | E-01 (93-103行目: chat_team) | ○ |
| C-18 | 作成者へのOwner権限付与 | E-01 (CreateService内) | ○ |
| C-19 | group_feature作成 | E-02 (244行目: create_or_load_association(:group_feature)) | ○ |
| C-20 | 組織IDの継承 | E-02 (organization関連) | ○ |
| C-21 | 階層制限の具体的な値 | **根拠なし** | △ |
| C-22 | Groups::CreateServiceの詳細実装 | **根拠なし（未読み込み）** | △ |

## 4) 不足情報（Unknown / Missing）
- 階層制限の具体的な設定値
  - 候補：`ApplicationSetting` / `Gitlab::CurrentSettings` / 設定ファイル
- Groups::CreateServiceの詳細実装
  - 候補：`app/services/groups/create_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェックロジック - 十分なカバレッジあり
- 0: 可視性継承ロジック - コード上で確認済み
- 1: CreateServiceの詳細 - 追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェック（create_subgroup）の実装が適切か確認
- [ ] subgroup_creation_levelのデフォルト値と選択肢を確認
- [ ] Groups::CreateServiceの実装を確認
- [ ] 階層制限の有無と設定方法を確認
- [ ] Mattermostチーム連携の動作を確認
