---
generated_at: 2026-01-22 13:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：130-Pagesドメイン管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **PagesDomainPresenterの詳細**：needs_verification?メソッドの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pages_domains_controller.rb` - PagesDomainsコントローラー（107行）
- E-02: `app/models/pages_domain.rb` - PagesDomainモデル（308行）
- E-03: `app/services/pages/domains/create_service.rb` - 作成サービス（55行）
- E-04: `app/services/pages/domains/update_service.rb` - 更新サービス（37行）
- E-05: `app/services/pages/domains/delete_service.rb` - 削除サービス（35行）
- E-06: `app/services/verify_pages_domain_service.rb` - 検証サービス（127行）
- E-07: `app/services/pages/domains/retry_acme_order_service.rb` - ACME再試行サービス（43行）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | require_pages_enabled!前提条件チェック | E-01 (6行目) | ○ |
| C-02 | authorize_update_pages!権限チェック | E-01 (7行目) | ○ |
| C-03 | feature_categoryがpages | E-01 (12行目) | ○ |
| C-04 | showアクションでneeds_verification?チェックと警告表示 | E-01 (14-18行目) | ○ |
| C-05 | verifyアクションでVerifyPagesDomainService呼び出し | E-01 (24-34行目), E-06 | ○ |
| C-06 | retry_auto_sslアクションでRetryAcmeOrderService呼び出し | E-01 (36-40行目), E-07 | ○ |
| C-07 | createアクションでPages::Domains::CreateService呼び出し | E-01 (46-54行目), E-03 | ○ |
| C-08 | updateアクションでPages::Domains::UpdateService呼び出し | E-01 (56-66行目), E-04 | ○ |
| C-09 | destroyアクションでPages::Domains::DeleteService呼び出し | E-01 (68-79行目), E-05 | ○ |
| C-10 | clean_certificateアクションで証明書クリア | E-01 (81-88行目) | ○ |
| C-11 | CreateServiceで重複ドメインチェック | E-03 (9-21行目) | ○ |
| C-12 | CreateServiceでPagesDomainCreatedEvent発行 | E-03 (25, 40-52行目) | ○ |
| C-13 | UpdateServiceでPagesDomainUpdatedEvent発行 | E-04 (11, 22-34行目) | ○ |
| C-14 | DeleteServiceでPagesDomainDeletedEvent発行 | E-05 (11, 20-32行目) | ○ |
| C-15 | VERIFICATION_KEY定数定義 | E-02 (9行目) | ○ |
| C-16 | VERIFICATION_THRESHOLD = 3.days | E-02 (10行目) | ○ |
| C-17 | SSL_RENEWAL_THRESHOLD = 30.days | E-02 (11行目) | ○ |
| C-18 | MAX_CERTIFICATE_KEY_LENGTH = 8192 | E-02 (13行目) | ○ |
| C-19 | 秘密鍵の暗号化（attr_encrypted、AES-256-CBC） | E-02 (49-53行目) | ○ |
| C-20 | VerifyPagesDomainServiceのDNS検証ロジック | E-06 (19-31, 87-105行目) | ○ |
| C-21 | RESOLVER_TIMEOUT_SECONDS = 15 | E-06 (7行目) | ○ |
| C-22 | PagesDomainPresenter.needs_verification?の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PagesDomainPresenterの実装詳細が未確認
  - 候補：`app/presenters/pages_domain_presenter.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー、サービス、モデルの主要ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PagesDomainPresenterのneeds_verification?実装を確認
- [ ] DNS検証の動作確認（TXTレコード形式）
- [ ] Let's Encrypt連携の動作確認
- [ ] イベント発行（EventStore）の動作確認
- [ ] 画面機能マッピング.csvとの整合性を確認
