---
generated_at: 2026-01-22 13:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：131-アラート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **リトライ仕様**：回数・間隔の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/alert_management/alert.rb`
- E-02: `app/controllers/projects/alert_management_controller.rb`
- E-03: `app/services/alert_management/alerts/update_service.rb`
- E-04: `app/services/alert_management/create_alert_issue_service.rb`
- E-05: `app/services/alert_management/http_integrations/create_service.rb`
- E-06: `app/helpers/projects/alert_management_helper.rb`
- E-07: `app/models/alert_management/http_integration.rb`
- E-08: `app/models/alert_management/alert_assignee.rb`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトル最大200文字 | E-01 (42行目: TITLE_MAX_LENGTH = 200) | ○ |
| C-02 | 説明最大1000文字 | E-01 (43行目: DESCRIPTION_MAX_LENGTH = 1_000) | ○ |
| C-03 | サービス名最大100文字 | E-01 (44行目: SERVICE_MAX_LENGTH = 100) | ○ |
| C-04 | モニタリングツール名最大100文字 | E-01 (45行目: TOOL_MAX_LENGTH = 100) | ○ |
| C-05 | ホスト配列最大255文字 | E-01 (46行目: HOSTS_MAX_LENGTH = 255) | ○ |
| C-06 | 重要度はcritical/high/medium/low/info/unknown | E-01 (63-70行目: enum :severity) | ○ |
| C-07 | ドメインはoperations/threat_monitoring | E-01 (72-75行目: enum :domain) | ○ |
| C-08 | fingerprintによる重複チェック | E-01 (56-60行目: validates :fingerprint, uniqueness) | ○ |
| C-09 | iidはプロジェクト内で一意 | E-01 (35行目: has_internal_id :iid, scope: :project) | ○ |
| C-10 | 閲覧権限チェック | E-02 (6行目: authorize_read_alert_management_alert!) | ○ |
| C-11 | 更新権限チェック | E-03 (42行目: can?(:update_alert_management_alert)) | ○ |
| C-12 | 担当者は閲覧権限が必要 | E-03 (99行目: can?(:read_alert_management_alert)) | ○ |
| C-13 | 1アラートにつき1イシューのみ | E-04 (19行目: error_issue_already_exists if alert.issue) | ○ |
| C-14 | イシュー作成には権限が必要 | E-04 (36-38行目: allowed? メソッド) | ○ |
| C-15 | HTTP統合作成には権限が必要 | E-05 (7行目: return error_no_permissions unless allowed?) | ○ |
| C-16 | HTTP統合数に制限がある | E-05 (15-18行目: too_many_integrations?) | ○ |
| C-17 | ステータス変更でシステムノート追加 | E-03 (134-135行目: add_status_change_system_note) | ○ |
| C-18 | 担当者変更でシステムノート追加 | E-03 (111-112行目: add_assignee_system_note) | ○ |
| C-19 | 解決時にTodoを解決 | E-03 (138-139行目: resolve_todos) | ○ |
| C-20 | 担当者変更でTodo再割り当て | E-03 (107-108行目: assign_todo) | ○ |
| C-21 | インシデント作成後にシステムノート | E-04 (60行目: SystemNoteService.new_alert_issue) | ○ |
| C-22 | 関連画面はアラート管理(100)と運用設定(114) | E-09 | ○ |
| C-23 | 機能はincident_managementカテゴリ | E-02 (9行目: feature_category :incident_management) | ○ |
| C-24 | イベント数インクリメント機能 | E-01 (151-152行目: register_new_event!) | ○ |
| C-25 | アラート参照形式は^alert# | E-01 (127-129行目: reference_prefix) | ○ |
| C-26 | Webhook実行機能 | E-01 (161-164行目: execute_integrations) | ○ |
| C-27 | パフォーマンス要件500ms/100ms | **根拠なし** | △ |
| C-28 | リトライは最大3回指数バックオフ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント / GitLab公式ドキュメント
- **リトライ仕様の詳細**
  - 理由：Webhook送信部分のリトライロジックは別モジュールで実装されている可能性
  - 候補：WebHookService / Sidekiq設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データモデル定義（ソースコードで確認済み）
- 0: 低リスク - 権限チェック（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - リトライ仕様（実装詳細の確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルール（文字数制限）がソースコードと一致しているか確認
- [ ] 権限チェックの記載が実装と一致しているか確認
- [ ] パフォーマンス要件について運用チームに確認
- [ ] Webhook リトライ仕様について実装を確認
- [ ] 関連画面マッピングが正しいか確認
