---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：132-エラートラッキング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **データモデル詳細**：EE版実装の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/error_tracking_controller.rb`
- E-02: `app/models/error_tracking.rb`
- E-03: `app/services/error_tracking/list_issues_service.rb`
- E-04: `app/services/error_tracking/issue_update_service.rb`
- E-05: `app/helpers/projects/error_tracking_helper.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ステータスはresolved/unresolved/ignoredの3種類 | E-03 (10-14行目: ISSUE_STATUS_VALUES) | ○ |
| C-02 | デフォルトステータスはunresolved | E-03 (5行目: DEFAULT_ISSUE_STATUS) | ○ |
| C-03 | デフォルト取得件数は20件 | E-03 (6行目: DEFAULT_LIMIT) | ○ |
| C-04 | デフォルトソートはlast_seen | E-03 (7行目: DEFAULT_SORT) | ○ |
| C-05 | 閲覧権限チェック | E-01 (6行目: authorize_read_sentry_issue!) | ○ |
| C-06 | 更新権限チェック | E-01 (7行目: authorize_update_sentry_issue!) | ○ |
| C-07 | indexアクションでHTML/JSON両対応 | E-01 (15-23行目: respond_to) | ○ |
| C-08 | detailsアクションでエラー詳細表示 | E-01 (25-33行目: details) | ○ |
| C-09 | updateアクションでステータス更新 | E-01 (35-44行目: update) | ○ |
| C-10 | 無効ステータスでBad Request | E-03 (42-43行目: invalid_status_error) | ○ |
| C-11 | 統合モードとSentryモードの切り替え | E-03 (73行目: integrated_client?) | ○ |
| C-12 | 統合モードで内部DB検索 | E-03 (84行目: error_repository.list_errors) | ○ |
| C-13 | Sentryモードで外部API呼び出し | E-03 (97行目: list_sentry_issues) | ○ |
| C-14 | カーソルベースページネーション | E-03 (86-88行目: pagination_hash) | ○ |
| C-15 | resolvedで関連イシュー自動クローズ | E-04 (28-36行目: close_and_create_note) | ○ |
| C-16 | イシュークローズ後にシステムノート | E-04 (44-45行目: create_system_note) | ○ |
| C-17 | キャッシュクリア処理 | E-04 (16行目: expire_issues_cache) | ○ |
| C-18 | SentryIssueFinder使用 | E-04 (48-52行目: related_issue) | ○ |
| C-19 | 権限不足時Unauthorized | E-04 (70-73行目: unauthorized) | ○ |
| C-20 | 関連画面マッピング | E-06 | ○ |
| C-21 | パフォーマンス要件500ms以内 | **根拠なし** | △ |
| C-22 | エラーモデル詳細構造 | **根拠なし（EE版確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント / GitLab公式ドキュメント
- **エラーモデルの詳細構造**
  - 理由：`error_tracking_errors`テーブルのモデル定義がEE版に含まれている可能性
  - 候補：`ee/app/models/error_tracking/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ステータス値定義（ソースコードで確認済み）
- 0: 低リスク - 権限チェック（ソースコードで確認済み）
- 0: 低リスク - モード切り替えロジック（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - EE版固有機能（ライセンス確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] ステータス値（resolved/unresolved/ignored）がソースコードと一致しているか確認
- [ ] デフォルト値（limit: 20, sort: last_seen, status: unresolved）が正しいか確認
- [ ] 統合モードとSentryモードの切り替え条件が正しいか確認
- [ ] 関連イシュー自動クローズの動作条件が正しいか確認
- [ ] EE版のエラーモデル定義を確認
