---
generated_at: 2026-01-22 13:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：133-デザインマネジメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **サービス層の詳細**：SaveDesignsService等の実装確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/design_management.rb`
- E-02: `app/models/design_management/design.rb`
- E-03: `app/models/design_management/version.rb`
- E-04: `app/models/design_management/action.rb`
- E-05: `app/models/design_management/repository.rb`
- E-06: `app/services/system_notes/design_management_service.rb`
- E-07: `app/graphql/types/design_management_type.rb`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル名最大255文字 | E-02 (42行目: length: { maximum: 255 }) | ○ |
| C-02 | 説明最大10000文字 | E-02 (43行目: MAX_TEXT_SIZE_LIMIT) | ○ |
| C-03 | ファイル名はイシュー内で一意 | E-02 (42行目: uniqueness: { scope: :issue_id }) | ○ |
| C-04 | プロジェクト・イシューとの関連 | E-02 (23-24行目: belongs_to) | ○ |
| C-05 | アクション・バージョンとの関連 | E-02 (26-28行目: has_many) | ○ |
| C-06 | iidはプロジェクト内で一意 | E-02 (36-38行目: has_internal_id) | ○ |
| C-07 | Noteableをinclude | E-02 (8行目: include Noteable) | ○ |
| C-08 | Mentionableをinclude | E-02 (11行目: include Mentionable) | ○ |
| C-09 | Todoableをinclude | E-02 (15行目: include Todoable) | ○ |
| C-10 | 相対位置による並び順 | E-02 (14行目: include RelativePositioning) | ○ |
| C-11 | ステータスはnew/current/deleted | E-02 (125-133行目: status) | ○ |
| C-12 | deleted?判定 | E-02 (135-137行目: deleted?) | ○ |
| C-13 | 参照形式#123[filename.png] | E-02 (164-169行目: to_reference) | ○ |
| C-14 | link_reference_patternの定義 | E-02 (175-186行目: link_reference_pattern) | ○ |
| C-15 | ファイルパス計算 | E-02 (188-189行目: build_full_path) | ○ |
| C-16 | visible_at_versionスコープ | E-02 (87-98行目: scope :visible_at_version) | ○ |
| C-17 | 安全な画像形式 | E-02 (9行目: Gitlab::FileTypeDetection) | ○ |
| C-18 | 危険な画像形式のフィーチャーフラグ | E-02 (244-246行目: allow_dangerous_images?) | ○ |
| C-19 | SVG形式のXSSリスク | E-02 (248-250行目: valid_file_extensions) | ○ |
| C-20 | イベント関連 | E-02 (34行目: has_many :events) | ○ |
| C-21 | ノート数キャッシュ | E-02 (219-221行目: user_notes_count) | ○ |
| C-22 | デザインディレクトリ | E-01 (6-8行目: designs_directory) | ○ |
| C-23 | パフォーマンス要件200ms | **根拠なし** | △ |
| C-24 | SaveDesignsServiceの詳細 | **根拠なし（別ファイル確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント
- **サービス層の詳細実装**
  - 理由：SaveDesignsService等のサービスクラスは別途確認が必要
  - 候補：`app/services/design_management/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データモデル定義（ソースコードで確認済み）
- 0: 低リスク - バリデーションルール（ソースコードで確認済み）
- 0: 低リスク - 参照形式（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - サービス層詳細（実装確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] ファイル名の一意性制約がソースコードと一致しているか確認
- [ ] ステータス値（new/current/deleted）の判定ロジックが正しいか確認
- [ ] 参照形式の生成ロジックが正しいか確認
- [ ] SVG形式のフィーチャーフラグ設定を確認
- [ ] デザインアップロードのサービス層実装を確認
