---
generated_at: 2026-01-22 13:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：134-組織管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **データモデル詳細**：organizationsテーブル構造の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/organizations/organizations_controller.rb`
- E-02: `app/controllers/admin/organizations_controller.rb`
- E-03: `app/finders/organizations/organizations_finder.rb`
- E-04: `app/graphql/resolvers/organizations/organizations_resolver.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リソース取得上限1000件 | E-01 (8行目: DEFAULT_RESOURCE_LIMIT = 1000) | ○ |
| C-02 | アクティビティ上限20件 | E-01 (9行目: DEFAULT_ACTIVITY_EVENT_LIMIT = 20) | ○ |
| C-03 | 閲覧権限チェック | E-01 (14行目: authorize_read_organization!) | ○ |
| C-04 | organization_switchingフィーチャーフラグ | E-01 (16行目: push_frontend_feature_flag) | ○ |
| C-05 | indexアクションで組織一覧 | E-01 (23行目: def index) | ○ |
| C-06 | newアクションで新規作成 | E-01 (25-27行目: def new) | ○ |
| C-07 | showアクションで詳細表示 | E-01 (29行目: def show) | ○ |
| C-08 | activityアクションでアクティビティ | E-01 (31-48行目: def activity) | ○ |
| C-09 | groups_and_projectsアクションでリソース一覧 | E-01 (50行目: def groups_and_projects) | ○ |
| C-10 | usersアクションでユーザー一覧 | E-01 (52-54行目: def users) | ○ |
| C-11 | EventCollectionでイベント収集 | E-01 (82行目: EventCollection.new) | ○ |
| C-12 | イベント可視性フィルタ | E-01 (41行目: visible_to_user?) | ○ |
| C-13 | ProjectsFinderでプロジェクト取得 | E-01 (68-72行目: projects) | ○ |
| C-14 | GroupsFinderでグループ取得 | E-01 (75-78行目: groups) | ○ |
| C-15 | Profile::EventSerializerでシリアライズ | E-01 (44行目: EventSerializer) | ○ |
| C-16 | 関連画面マッピング | E-05 | ○ |
| C-17 | feature_category :organization | E-01 (11行目: feature_category) | ○ |
| C-18 | JSONレスポンス対応 | E-01 (33-45行目: respond_to) | ○ |
| C-19 | パフォーマンス要件200ms/300ms | **根拠なし** | △ |
| C-20 | organizationsテーブル構造詳細 | **根拠なし（モデル確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント
- **organizationsテーブルの詳細構造**
  - 理由：Organizationモデルの詳細確認が必要
  - 候補：`app/models/organization.rb` / DBスキーマ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 定数定義（ソースコードで確認済み）
- 0: 低リスク - 権限チェック（ソースコードで確認済み）
- 0: 低リスク - アクション定義（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - データモデル詳細（モデル確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] リソース取得上限（1000件）がソースコードと一致しているか確認
- [ ] アクティビティ取得上限（20件）が正しいか確認
- [ ] フィーチャーフラグの設定状態を確認
- [ ] EventCollectionの動作を確認
- [ ] Organizationモデルの詳細を確認
