---
generated_at: 2026-01-22 13:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：135-MLモデルレジストリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **MLflow API詳細**：API実装の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/ml/model.rb`
- E-02: `app/controllers/projects/ml/models_controller.rb`
- E-03: `app/services/ml/create_model_service.rb`
- E-04: `app/models/ml/experiment.rb`
- E-05: `app/models/ml/candidate.rb`
- E-06: `app/models/ml/model_version.rb`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モデル名最大255文字 | E-01 (16行目: length: { maximum: 255 }) | ○ |
| C-02 | 説明最大10000文字 | E-01 (19-20行目: length: { maximum: 10_000 }) | ○ |
| C-03 | プロジェクト内でモデル名は一意 | E-01 (14行目: uniqueness: { scope: :project }) | ○ |
| C-04 | モデル名形式の正規表現 | E-01 (14行目: Gitlab::Regex.ml_model_name_regex) | ○ |
| C-05 | デフォルト実験自動作成 | E-01 (9行目: EXPERIMENT_NAME_PREFIX, 64-66行目) | ○ |
| C-06 | 実験名プレフィックス[model] | E-01 (9行目: EXPERIMENT_NAME_PREFIX = '[model]') | ○ |
| C-07 | バージョン関連 | E-01 (25行目: has_many :versions) | ○ |
| C-08 | 候補関連 | E-01 (26行目: has_many :candidates) | ○ |
| C-09 | メタデータ関連 | E-01 (27行目: has_many :metadata) | ○ |
| C-10 | 最新バージョン取得 | E-01 (28行目: has_one :latest_version) | ○ |
| C-11 | バージョン数カウントスコープ | E-01 (32-39行目: with_version_count) | ○ |
| C-12 | デフォルト実験整合性検証 | E-01 (49-54行目: valid_default_experiment?) | ○ |
| C-13 | プロジェクトIDとIDでの検索 | E-01 (56-58行目: by_project_id_and_id) | ○ |
| C-14 | プロジェクトIDと名前での検索 | E-01 (60-62行目: by_project_id_and_name) | ○ |
| C-15 | 閲覧権限チェック | E-02 (6行目: authorize_read_model_registry!) | ○ |
| C-16 | 書き込み権限チェック | E-02 (7行目: authorize_write_model_registry!) | ○ |
| C-17 | ページあたり最大20件 | E-02 (11行目: MAX_MODELS_PER_PAGE = 20) | ○ |
| C-18 | feature_category :mlops | E-02 (9行目: feature_category :mlops) | ○ |
| C-19 | destroyアクションでモデル削除 | E-02 (21-26行目: def destroy) | ○ |
| C-20 | 関連画面マッピング | E-07 | ○ |
| C-21 | CacheMarkdownField使用 | E-01 (7行目: include CacheMarkdownField) | ○ |
| C-22 | パッケージとの関連 | E-01 (45-47行目: all_packages) | ○ |
| C-23 | パフォーマンス要件200ms | **根拠なし** | △ |
| C-24 | MLflow API詳細 | **根拠なし（API実装確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント
- **MLflow互換API詳細**
  - 理由：MLflow API実装は`lib/api/ml/mlflow/`に別途確認が必要
  - 候補：`lib/api/ml/mlflow/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データモデル定義（ソースコードで確認済み）
- 0: 低リスク - バリデーションルール（ソースコードで確認済み）
- 0: 低リスク - 権限チェック（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - MLflow API（実装確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] モデル名の一意性制約とバリデーションがソースコードと一致しているか確認
- [ ] デフォルト実験の自動作成ロジックが正しいか確認
- [ ] バージョン数カウントのスコープが正しく動作するか確認
- [ ] 権限チェックの条件が正しいか確認
- [ ] MLflow互換APIの実装を確認
