---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：136-アクティビティフィード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **EventCollection詳細**：実装詳細の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/event.rb`
- E-02: `app/services/events/render_service.rb`
- E-03: `app/services/events/destroy_service.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション種別12種類 | E-01 (15-28行目: ACTIONS) | ○ |
| C-02 | PROJECT_ACTIONS定義 | E-01 (32行目: PROJECT_ACTIONS) | ○ |
| C-03 | WIKI_ACTIONS定義 | E-01 (33行目: WIKI_ACTIONS) | ○ |
| C-04 | DESIGN_ACTIONS定義 | E-01 (34行目: DESIGN_ACTIONS) | ○ |
| C-05 | TARGET_TYPES定義 | E-01 (39-49行目: TARGET_TYPES) | ○ |
| C-06 | enum :action定義 | E-01 (56行目: enum :action) | ○ |
| C-07 | contributionsスコープ | E-01 (113-124行目: contributions) | ○ |
| C-08 | visible_to_user?メソッド | E-01 (179-185行目: visible_to_user?) | ○ |
| C-09 | capabilityメソッド | E-01 (450-458行目: capability) | ○ |
| C-10 | capabilitiesマッピング | E-01 (460-472行目: capabilities) | ○ |
| C-11 | action_nameメソッド | E-01 (299-329行目: action_name) | ○ |
| C-12 | update_projectコールバック | E-01 (85行目: after_create :update_project) | ○ |
| C-13 | reset_project_activityメソッド | E-01 (418-432行目: reset_project_activity) | ○ |
| C-14 | RESET_PROJECT_ACTIVITY_INTERVAL | E-01 (51行目: 1.hour) | ○ |
| C-15 | プレゼンター定義 | E-01 (175-177行目: present) | ○ |
| C-16 | fingerprint属性 | E-01 (55行目: sha_attribute :fingerprint) | ○ |
| C-17 | with_associationsスコープ | E-01 (126-131行目: with_associations) | ○ |
| C-18 | import時スキップ | E-01 (85行目: unless: :imported?) | ○ |
| C-19 | 関連画面マッピング | E-04 | ○ |
| C-20 | PushEventサブクラス | E-01 (158-163行目: find_sti_class) | ○ |
| C-21 | パフォーマンス要件300ms | **根拠なし** | △ |
| C-22 | EventCollection詳細 | **根拠なし（別ファイル確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント
- **EventCollection詳細実装**
  - 理由：EventCollectionクラスの詳細確認が必要
  - 候補：`app/models/event_collection.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アクション種別定義（ソースコードで確認済み）
- 0: 低リスク - 可視性チェック（ソースコードで確認済み）
- 0: 低リスク - コールバック処理（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - EventCollection（実装確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] アクション種別がソースコードと一致しているか確認
- [ ] visible_to_user?の権限チェックロジックが正しいか確認
- [ ] update_projectコールバックの動作を確認
- [ ] EventCollectionの実装を確認
- [ ] イベント保持期間の設定を確認
