---
generated_at: 2026-01-22 13:30:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：137-メール通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **レート制限の閾値**：具体的な数値の根拠不足
  2. **SMTP設定詳細**：設定ファイルの確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb`
- E-02: `app/models/notification_setting.rb`
- E-03: `app/mailers/notify.rb`
- E-04: `app/mailers/emails/issues.rb`
- E-05: `app/services/notification_recipients/build_service.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Asyncクラスで非同期通知 | E-01 (29-43行目: class Async) | ○ |
| C-02 | MailScheduler::NotificationServiceWorker使用 | E-01 (41行目: MailScheduler::NotificationServiceWorker.perform_async) | ○ |
| C-03 | new_issueメソッド存在 | E-01 (209-211行目: def new_issue) | ○ |
| C-04 | new_merge_requestメソッド存在 | E-01 (282-284行目: def new_merge_request) | ○ |
| C-05 | new_noteメソッド存在 | E-01 (469-477行目: def new_note) | ○ |
| C-06 | pipeline_finishedメソッド存在 | E-01 (562-584行目: def pipeline_finished) | ○ |
| C-07 | mailerメソッドでNotify参照 | E-01 (878-880行目: def mailer; Notify; end) | ○ |
| C-08 | receive_notifications権限チェック | E-01 (50行目: user.can?(:receive_notifications)) | ○ |
| C-09 | can_trigger_notifications?チェック | E-01 (806行目: current_user&.can_trigger_notifications?) | ○ |
| C-10 | 通知レベルenum定義 | E-02 (7行目: enum :level, { global: 3, watch: 2, participating: 1, mention: 4, disabled: 0, custom: 5 }) | ○ |
| C-11 | EMAIL_EVENTS定義 | E-02 (38-58行目: EMAIL_EVENTS) | ○ |
| C-12 | EXCLUDED_WATCHER_EVENTS定義 | E-02 (60-66行目: EXCLUDED_WATCHER_EVENTS) | ○ |
| C-13 | event_enabled?メソッド | E-02 (116-122行目: def event_enabled?) | ○ |
| C-14 | failed_pipeline/fixed_pipelineデフォルト有効 | E-02 (102-114行目) | ○ |
| C-15 | Notifyクラスでメールモジュールinclude | E-03 (11-30行目: include Emails::*) | ○ |
| C-16 | senderメソッド | E-03 (83-96行目: def sender) | ○ |
| C-17 | subjectメソッド | E-03 (116-125行目: def subject) | ○ |
| C-18 | mail_threadメソッド | E-03 (135-159行目: def mail_thread) | ○ |
| C-19 | add_model_headersメソッド | E-03 (218-232行目: def add_model_headers) | ○ |
| C-20 | check_rate_limitメソッド | E-03 (283-305行目: def check_rate_limit) | ○ |
| C-21 | X-GitLab-ConfidentialIssueヘッダー | E-04 (202行目: 'X-GitLab-ConfidentialIssue') | ○ |
| C-22 | SentNotification.record呼び出し | E-04 (191行目: @sent_notification = SentNotification.record) | ○ |
| C-23 | BuildService.build_recipients | E-05 (16-18行目: def self.build_recipients) | ○ |
| C-24 | notifiable_usersメソッド | E-05 (8-10行目: def self.notifiable_users) | ○ |
| C-25 | レート制限の具体的閾値 | **根拠なし** | △ |
| C-26 | SMTP設定詳細 | **根拠なし（設定ファイル確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **レート制限の具体的閾値**
  - 理由：ApplicationRateLimiterの設定値がソースコード上で確認できない
  - 候補：`config/initializers/` / 環境変数設定
- **SMTP設定詳細**
  - 理由：メール送信設定は環境依存
  - 候補：`config/environments/*.rb` / `config/gitlab.yml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知レベル定義（ソースコードで確認済み）
- 0: 低リスク - Asyncクラス処理（ソースコードで確認済み）
- 0: 低リスク - メールモジュール構成（ソースコードで確認済み）
- 0: 低リスク - 受信者決定ロジック（ソースコードで確認済み）
- 1: 中リスク - レート制限設定（設定値の確認推奨）
- 1: 中リスク - SMTP設定（環境依存のため確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 通知レベルの種類がソースコードと一致しているか確認
- [ ] EMAIL_EVENTSのイベント一覧が正しいか確認
- [ ] 非同期処理のワーカー設定を確認
- [ ] レート制限の設定値を確認
- [ ] SMTP設定の環境依存部分を確認
