---
generated_at: 2026-01-22 13:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：138-Web通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **GraphQL Trigger詳細**：実装ファイルの確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/todo.rb`
- E-02: `app/services/todo_service.rb`
- E-03: `app/controllers/dashboard/todos_controller.rb`
- E-04: `app/channels/graphql_channel.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WAIT_FOR_DELETE = 1.hour | E-01 (11行目) | ○ |
| C-02 | ASSIGNED = 1 | E-01 (14行目) | ○ |
| C-03 | MENTIONED = 2 | E-01 (15行目) | ○ |
| C-04 | BUILD_FAILED = 3 | E-01 (16行目) | ○ |
| C-05 | MARKED = 4 | E-01 (17行目) | ○ |
| C-06 | UNMERGEABLE = 6 | E-01 (19行目) | ○ |
| C-07 | DIRECTLY_ADDRESSED = 7 | E-01 (20行目) | ○ |
| C-08 | REVIEW_REQUESTED = 9 | E-01 (22行目) | ○ |
| C-09 | MEMBER_ACCESS_REQUESTED = 10 | E-01 (23行目) | ○ |
| C-10 | SSH_KEY_EXPIRED = 14 | E-01 (27行目) | ○ |
| C-11 | SSH_KEY_EXPIRING_SOON = 15 | E-01 (28行目) | ○ |
| C-12 | ACTION_NAMES定義 | E-01 (34-47行目) | ○ |
| C-13 | ACTIONS_MULTIPLE_ALLOWED | E-01 (49行目) | ○ |
| C-14 | PARENTLESS_ACTION_TYPES | E-01 (52-55行目) | ○ |
| C-15 | BATCH_DELETE_SIZE = 100 | E-01 (57行目) | ○ |
| C-16 | state_machine定義 | E-01 (118-125行目) | ○ |
| C-17 | resolved_by_action enum | E-01 (116行目) | ○ |
| C-18 | TodoService.BATCH_SIZE = 100 | E-02 (13行目) | ○ |
| C-19 | new_issueメソッド | E-02 (20-22行目) | ○ |
| C-20 | reassigned_assignableメソッド | E-02 (60-62行目) | ○ |
| C-21 | new_merge_requestメソッド | E-02 (77-79行目) | ○ |
| C-22 | resolve_todos_for_targetメソッド | E-02 (219-225行目) | ○ |
| C-23 | bulk_insert_todosメソッド | E-02 (352-365行目) | ○ |
| C-24 | feature_category :notifications | E-03 (6行目) | ○ |
| C-25 | GraphqlChannel.subscribedメソッド | E-04 (7-31行目) | ○ |
| C-26 | GraphqlChannel.unsubscribedメソッド | E-04 (33-39行目) | ○ |
| C-27 | パフォーマンス要件200ms | **根拠なし** | △ |
| C-28 | GraphqlTriggers詳細 | **根拠なし（実装確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント
- **GraphqlTriggers実装詳細**
  - 理由：graphql_triggers.rbの詳細確認が必要
  - 候補：`app/graphql/graphql_triggers.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アクション定数定義（ソースコードで確認済み）
- 0: 低リスク - state_machine定義（ソースコードで確認済み）
- 0: 低リスク - TodoService処理（ソースコードで確認済み）
- 0: 低リスク - GraphqlChannel処理（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - GraphqlTriggers（実装確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] アクション種別がソースコードと一致しているか確認
- [ ] ACTIONS_MULTIPLE_ALLOWEDの内容が正しいか確認
- [ ] state_machineの遷移が正しいか確認
- [ ] GraphqlChannelの認証処理を確認
- [ ] GraphqlTriggersの実装を確認
