---
generated_at: 2026-01-22 13:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：139-監査イベント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **YAML定義ファイル一覧**：定義ファイルの網羅確認必要
  2. **EEストリーム配信詳細**：EE専用機能の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/audit_event.rb`
- E-02: `lib/gitlab/audit/auditor.rb`
- E-03: `lib/gitlab/audit/null_author.rb`
- E-04: `app/services/audit_event_service.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PARALLEL_PERSISTENCE_COLUMNS定義 | E-01 (10-16行目) | ○ |
| C-02 | 月次パーティショニング | E-01 (20行目: partitioned_by :created_at, strategy: :monthly) | ○ |
| C-03 | details Hash serialize | E-01 (22行目: serialize :details, type: Hash) | ○ |
| C-04 | author_id必須バリデーション | E-01 (26行目: validates :author_id, presence: true) | ○ |
| C-05 | entity_id必須バリデーション | E-01 (27行目: validates :entity_id, presence: true) | ○ |
| C-06 | entity_type必須バリデーション | E-01 (28行目: validates :entity_type, presence: true) | ○ |
| C-07 | ip_address検証 | E-01 (29行目: validates :ip_address, ip_address: true) | ○ |
| C-08 | by_entity_typeスコープ | E-01 (31行目) | ○ |
| C-09 | by_entity_idスコープ | E-01 (32行目) | ○ |
| C-10 | sanitize_messageメソッド | E-01 (109-115行目) | ○ |
| C-11 | parallel_persistメソッド | E-01 (121-128行目) | ○ |
| C-12 | BatchLoaderによるlazy_author | E-01 (81-87行目) | ○ |
| C-13 | PERMITTED_TARGET_CLASSES | E-02 (10-12行目) | ○ |
| C-14 | audit静的メソッド | E-02 (52-64行目) | ○ |
| C-15 | YAML定義必須チェック | E-02 (87-89行目: StandardError raise) | ○ |
| C-16 | single_auditメソッド | E-02 (92-96行目) | ○ |
| C-17 | recordメソッド | E-02 (103-105行目) | ○ |
| C-18 | log_events_and_streamメソッド | E-02 (107-117行目) | ○ |
| C-19 | log_to_databaseメソッド | E-02 (191-203行目) | ○ |
| C-20 | bulk_insert対応 | E-02 (196行目: AuditEvent.bulk_insert!) | ○ |
| C-21 | NullAuthor.for著者種別判定 | E-03 (18-35行目) | ○ |
| C-22 | UnauthenticatedAuthor ID=-1 | E-03 (26-27行目) | ○ |
| C-23 | DeployTokenAuthor ID=-2 | E-03 (28-29行目) | ○ |
| C-24 | DeployKeyAuthor ID=-3 | E-03 (30-31行目) | ○ |
| C-25 | YAML定義ファイル一覧 | **根拠なし（定義ファイル確認必要）** | △ |
| C-26 | EEストリーム配信詳細 | **根拠なし（EE機能）** | △ |

## 4) 不足情報（Unknown / Missing）
- **YAML定義ファイル一覧**
  - 理由：監査イベントタイプのYAML定義ファイルの網羅確認が必要
  - 候補：`config/audit_events/types/` ディレクトリ
- **EEストリーム配信詳細**
  - 理由：外部ストリーム配信はEE専用機能
  - 候補：`ee/lib/gitlab/audit/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル定義（ソースコードで確認済み）
- 0: 低リスク - バリデーションルール（ソースコードで確認済み）
- 0: 低リスク - パーティショニング設定（ソースコードで確認済み）
- 0: 低リスク - Author種別判定（ソースコードで確認済み）
- 1: 中リスク - YAML定義ファイル（ファイル一覧の確認推奨）
- 1: 中リスク - EEストリーム機能（EE機能のため確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] PARALLEL_PERSISTENCE_COLUMNSがソースコードと一致しているか確認
- [ ] 月次パーティショニングの設定が正しいか確認
- [ ] バリデーションルールがソースコードと一致しているか確認
- [ ] NullAuthorの著者種別判定が正しいか確認
- [ ] YAML定義ファイルの存在を確認
- [ ] EEストリーム配信機能を確認（必要に応じて）
