---
generated_at: 2026-01-22 13:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：140-監査ログ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足
  2. **Finder詳細**：EE専用のFinderクラス確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/audit_event.rb`
- E-02: `app/graphql/types/audit_events/audit_event_type.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | by_entity_typeスコープ | E-01 (31行目) | ○ |
| C-02 | by_entity_idスコープ | E-01 (32行目) | ○ |
| C-03 | by_author_idスコープ | E-01 (33行目) | ○ |
| C-04 | supported_keyset_orderings | E-01 (48-50行目: { id: [:desc] }) | ○ |
| C-05 | order_byメソッド | E-01 (52-59行目) | ○ |
| C-06 | BatchLoaderによるlazy_author | E-01 (81-87行目) | ○ |
| C-07 | as_jsonでip_address変換 | E-01 (89-93行目) | ○ |
| C-08 | GraphQL idフィールド | E-02 (10-11行目) | ○ |
| C-09 | GraphQL created_atフィールド | E-02 (13-14行目) | ○ |
| C-10 | GraphQL authorフィールド | E-02 (16-17行目) | ○ |
| C-11 | GraphQL event_nameフィールド | E-02 (19-20行目) | ○ |
| C-12 | GraphQL detailsフィールド | E-02 (22-23行目) | ○ |
| C-13 | GraphQL target_typeフィールド | E-02 (25-26行目) | ○ |
| C-14 | GraphQL target_detailsフィールド | E-02 (28-29行目) | ○ |
| C-15 | GraphQL target_idフィールド | E-02 (31-32行目) | ○ |
| C-16 | GraphQL ip_addressフィールド | E-02 (34-35行目) | ○ |
| C-17 | GraphQL entity_pathフィールド | E-02 (37-38行目) | ○ |
| C-18 | GraphQL projectフィールド | E-02 (46-47行目) | ○ |
| C-19 | GraphQL groupフィールド | E-02 (49-50行目) | ○ |
| C-20 | details to_json変換 | E-02 (55-59行目) | ○ |
| C-21 | パフォーマンス要件200ms | **根拠なし** | △ |
| C-22 | AuditEventsFinder詳細 | **根拠なし（EE確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**
  - 理由：ソースコード上にSLO/SLA定義が見当たらない
  - 候補：インフラ設定ファイル / 運用ドキュメント
- **AuditEventsFinder詳細**
  - 理由：Finderクラスの実装確認が必要（EE専用の可能性）
  - 候補：`ee/app/finders/audit_events_finder.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スコープ定義（ソースコードで確認済み）
- 0: 低リスク - Keyset Pagination対応（ソースコードで確認済み）
- 0: 低リスク - GraphQL型定義（ソースコードで確認済み）
- 0: 低リスク - BatchLoader使用（ソースコードで確認済み）
- 1: 中リスク - パフォーマンス要件（運用観点での確認推奨）
- 1: 中リスク - Finder実装（EE機能のため確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] スコープ定義がソースコードと一致しているか確認
- [ ] supported_keyset_orderingsが正しいか確認
- [ ] GraphQL型のフィールドがソースコードと一致しているか確認
- [ ] BatchLoaderの実装が正しいか確認
- [ ] EE専用のFinderクラスを確認（必要に応じて）
